package com.joyy.hagorpc.internal

import com.joyy.hagorpc.IMemoryChangeListener
import com.joyy.hagorpc.NotifyBundle
import kotlin.jvm.Volatile

//线程不安全，因为目前所有方法都只会在一个线程里面调用
class NotifyFrequencyHandler(
    private val mFinalHandler: INotifyHandler,
) : INotifyHandler, IMemoryChangeListener {
    private var mHandlerHashMap: MutableMap<String, OneNotifyFrequencyHandler>? = null

    @Volatile
    private var mIsLowMemory = false

    init {
        RPCCore.mMemoryDelegate.onObserveMemory(this)
    }

    override fun onLowMemory() {
        mIsLowMemory = true
    }

    override fun notify(bundle: NotifyBundle) {
        val frequencyDelegate = RPCCore.mNotifyFrequencyDelegate
        val newDuration = frequencyDelegate.getIntervalTime(
            bundle.protocol.header.sname,
            bundle.protocol.uri
        )
        var handlerHashMap = mHandlerHashMap
        if (handlerHashMap != null) {
            val keys: Set<String> = handlerHashMap.keys
            var item: OneNotifyFrequencyHandler?
            for (key in keys) {
                item = handlerHashMap[key]
                item?.updateTime(newDuration)
            }
        }
        if (mIsLowMemory) {
            if (handlerHashMap != null && handlerHashMap.size > 200) {
                val keys: Set<String> = handlerHashMap.keys
                var item: OneNotifyFrequencyHandler?
                for (key in keys) {
                    item = handlerHashMap[key]
                    if (item != null && !item.hasNotifyNotHandler()) {
                        handlerHashMap.remove(key)
                    }
                }
            }
            mIsLowMemory = false
        }
        val service = bundle.protocol.header.sname
        val uri = bundle.protocol.uri
        val controlForBoth = frequencyDelegate.isControl(service, uri ?: 0)
        var controlForService = false
        if (!controlForBoth) {
            controlForService = frequencyDelegate.isControl(service)
        }
        var handler: OneNotifyFrequencyHandler? = null
        //支持sname + uri的精确控制；所以先找最精确的
        if (handlerHashMap != null) {
            handler = if (controlForBoth) {
                handlerHashMap["$service&&$uri"]
            } else {
                handlerHashMap[service]
            }
        }
        if (!controlForBoth && !controlForService) {
            //还有通知待处理的话，需要将当前也交给处理器，保证通知的执行顺序；
            if (handler != null && handler.hasNotifyNotHandler()) {
                handler.notify(bundle)
            } else {
                if (handler != null) {
                    mHandlerHashMap?.remove(service)
                }
                mFinalHandler.notify(bundle)
            }
            return
        }
        if (handlerHashMap == null) {
            handlerHashMap = HashMap()
            mHandlerHashMap = handlerHashMap
        }
        if (handler == null) {
            if (controlForBoth) {
                handler = OneNotifyFrequencyHandler(
                    service, uri ?: 0, mFinalHandler,
                    newDuration
                )
                handlerHashMap["$service&&$uri"] = handler
            } else {
                handler = OneNotifyFrequencyHandler(
                    service, -1, mFinalHandler,
                    newDuration
                )
                handlerHashMap[service] = handler
            }
        }
        handler.notify(bundle)
    }

    override fun notify(bundleList: List<NotifyBundle>) {
        for (bundle in bundleList) {
            notify(bundle)
        }
    }

    companion object {
        private const val TAG = "NotifyFrequencyHandler"
    }
}