package com.joyy.hagorpc.internal

import com.joyy.hagorpc.IRPCNotify
import com.joyy.hagorpc.RPCNotifyExtra

/**
 * fixme 支持缓存
 * 通知行为（里面已经带有监听者和数据，这个数据可为缓存，减少频繁的创建）
 * Created by wjh on 2021/10/22
 */
class NotifyAction private constructor() {

    companion object {
        fun obtain(): NotifyAction {
            return NotifyAction()
        }
    }

    var payload: ByteArray = ByteArray(0)
    var extra: RPCNotifyExtra? = null
    var uiObserver: List<IRPCNotify> = emptyList()
    var threadObserver: List<IRPCNotify> = emptyList()


    override fun toString(): String {
        return "NotifyAction(payloadSize=${payload.size}, extra=$extra, " +
                "uiObserverSize=${uiObserver.size}, threadObserverSize=${threadObserver.size})"
    }

    fun recycle() {
    }
}