package com.joyy.hagorpc.internal

import android.util.Log
import com.joyy.hagorpc.ILogger
import com.joyy.hagorpc.impl.DefaultLogger
import org.msgpack.core.MessagePack
import org.msgpack.core.MessageUnpacker
import org.msgpack.value.Value
import org.msgpack.value.Variable
import org.msgpack.value.impl.ImmutableStringValueImpl
import java.io.*
import java.util.zip.GZIPInputStream
import java.util.zip.ZipEntry
import java.util.zip.ZipOutputStream

/**
 * Created by lulong on 2018/5/12.
 * Email:lulong@joyy.sg
 */
object GzipUtils {
    private const val TAG = "GzipUtils"

    @Volatile
    private var sLogger: ILogger = DefaultLogger()
    private const val BUFFER = 2048

    fun setLogger(logger: ILogger) {
        sLogger = logger
    }

    fun gzipPack(resData: ByteArray?): ByteArray? {
        var bytes: ByteArray?
        var startTime: Long = -1
        if (sLogger.isDebuggable()) {
            startTime = System.currentTimeMillis()
        }
        var unpacker: MessageUnpacker? = null
        var iszip = false
        var len = -1
        var data: ByteArray? = null
        try {
            unpacker = MessagePack.newDefaultUnpacker(resData)
            val variable = Variable()
            unpacker.unpackValue(variable)
            var valueMap: Map<Value?, Value?>? = null
            if (variable.isMapValue) {
                val mapValue = variable.asMapValue()
                valueMap = mapValue.map()
            }
            if (valueMap != null) {
                var value = valueMap[ImmutableStringValueImpl("IsZip")]
                if (value != null && value.isBooleanValue) {
                    iszip = value.asBooleanValue().boolean
                }
                value = valueMap[ImmutableStringValueImpl("ZipDataLen")]
                if (value != null && value.isIntegerValue) {
                    len = value.asIntegerValue().asInt()
                }
            }
            if (len > 0) {
                data = ByteArray(len)
                unpacker.readPayload(data)
            }
            bytes = data
            if (len > 0) {
                if (iszip) {
                    bytes = decompressForGzip(bytes)
                }
            } else {
                bytes = resData
            }
        } catch (e: Exception) {
            if (unpacker != null) {
                try {
                    unpacker.close()
                } catch (e2: Exception) {
                    sLogger.logE(TAG, "", e2)
                }
            }
            bytes = resData
            sLogger.logE(TAG, "", e)
        }
        if (sLogger.isDebuggable()) {
            sLogger.logD(TAG, "onResponse gzip comsume:" + (System.currentTimeMillis() - startTime))
        }
        return bytes
    }

    fun decompressForGzip(gzipStr: ByteArray?): ByteArray? {
        var out: ByteArrayOutputStream? = null
        var `in`: ByteArrayInputStream? = null
        var gzip: GZIPInputStream? = null
        try {
            val buff = ByteArray(1024)
            var len: Int
            out = ByteArrayOutputStream()
            `in` = ByteArrayInputStream(gzipStr)
            gzip = GZIPInputStream(`in`)
            while (gzip.read(buff).also { len = it } != -1) {
                out.write(buff, 0, len)
            }
            val byteArray = out.toByteArray()
            gzip.close()
            `in`.close()
            out.close()
            return byteArray
        } catch (e: IOException) {
            sLogger.logE(TAG, "", e)
            try {
                gzip?.close()
                `in`?.close()
                out?.close()
            } catch (e1: Exception) {
                sLogger.logE(TAG, "", e1)
            }
        }
        return null
    }

    fun zip(_files: Array<String>, zipFileName: String?) {
        try {
            var origin: BufferedInputStream?
            val dest = FileOutputStream(zipFileName)
            val out = ZipOutputStream(BufferedOutputStream(dest))
            val data = ByteArray(1024)
            for (i in _files.indices) {
                Log.v(TAG, "zip Adding: " + _files[i])
                val fi = FileInputStream(_files[i])
                origin = BufferedInputStream(fi, BUFFER)
                val entry = ZipEntry(_files[i].substring(_files[i].lastIndexOf("/") + 1))
                out.putNextEntry(entry)
                var count: Int
                while (origin.read(data, 0, BUFFER).also { count = it } != -1) {
                    out.write(data, 0, count)
                }
                origin.close()
            }
            out.close()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}