package com.joyy.hagorpc.internal

import android.os.Handler
import android.os.HandlerThread
import android.os.SystemClock
import android.util.Log
import com.joyy.hagorpc.IFrequencyExecutor

/**
 * 带频率限制的任务执行器
 * Created by wjh on 2021/10/28
 */
class FrequencyExecutorImp(duration: Long) : IFrequencyExecutor {

    private val TAG = "FrequencyExecutorImp"

    @Volatile
    private var mDuration: Long = duration

    private var mRealExecuteTime: Long = 0

    private var mLastDelayTime: Long = 0

    private var mRealExecuteTask: Runnable? = null

    private var mCacheTask: Runnable? = null

    private var mDiscardNum: Int = 0
    private val mHandler: Handler

    init {
        val thread = HandlerThread("rpc_frequency_thread")
        thread.start()
        mHandler = Handler(thread.looper)
    }

    @Synchronized
    override fun execute(task: Runnable) {
        if (mDuration <= 0) {
            mHandler.post(task)
            return
        }
        mRealExecuteTask = task

        val duration: Long = mDuration
        val curTime = SystemClock.uptimeMillis()
        val timeGap: Long = curTime - mRealExecuteTime
        var delayTime: Long = 0
        if (curTime > 0 && mRealExecuteTime > 0 && timeGap >= 0 && timeGap < duration) {
            if (timeGap > 0) {
                delayTime = duration - timeGap
            } else if (timeGap == 0L) {
                delayTime = duration
            }
            if (delayTime > duration) {
                delayTime = duration
            }
            mLastDelayTime = delayTime
        } else {
            mLastDelayTime = delayTime
        }

        if (mCacheTask != null) {
            mCacheTask?.let {
                mHandler.removeCallbacks(it)
            }
        } else {
            mCacheTask = Runnable { executeReal() }
        }

        if (delayTime > 0) {
            mDiscardNum++

            Log.d(TAG, "discard: $mDiscardNum, task: $task, delay: $delayTime")
            mCacheTask?.let {
                mHandler.postDelayed(it, delayTime)
            }
        } else {
            Log.d(TAG, "execute discard: $mDiscardNum, task: $task")
            executeReal()
        }
    }

    override fun update(duration: Long) {
        if (mDuration != duration) {
            innerUpdate(duration)
        }
    }

    @Synchronized
    private fun innerUpdate(duration: Long) {
        if (mDuration != duration) {
            mDuration = duration

            mCacheTask?.let {
                mHandler.removeCallbacks(it)
            }

            executeReal()
        }
    }

    @Synchronized
    private fun executeReal() {
        mRealExecuteTime = SystemClock.uptimeMillis()

        mRealExecuteTask?.let {
            mHandler.post(it)
            mRealExecuteTask = null
        }
    }
}