package com.joyy.hagorpc.impl

import com.joyy.hagorpc.IFrequencyExecutor
import com.joyy.hagorpc.INotifyFrequencyDelegate
import com.joyy.hagorpc.NotifyBundle
import com.joyy.hagorpc.internal.FrequencyExecutorImp

/**
 * rpc默认广播单播处理频度控制
 * Created by wjh on 2021/10/29
 */
open class DefaultNotifyFrequency : INotifyFrequencyDelegate {

    private var mDuration: Long = 0

    override fun createExecutor(duration: Long): IFrequencyExecutor {
        return FrequencyExecutorImp(duration)
    }

    override fun getIntervalTime(sname: String, uri: Int): Long {
        return mDuration
    }

    override fun canReplace(sname: String, uri: Int): Boolean {
        return false
    }

    override fun onBatch(sname: String, uri: Int): Int {
        return -1
    }

    override fun isControl(sname: String): Boolean {
        return false
    }

    override fun isControl(sname: String, uri: Int): Boolean {
        return false
    }

    override fun onAfterNotify(
        sname: String,
        uriList: List<Int>,
        lastNotifyTime: Long,
        thisNotifyTime: Long,
        receiveTime: Long
    ) {
        // do nothing
    }

    override fun intercept(dataList: List<NotifyBundle>): List<NotifyBundle> {
        return dataList
    }
}