package com.joyy.hagorpc.impl

import android.content.Context
import android.util.Log
import com.joyy.hagorpc.INetworkChangeListener
import com.joyy.hagorpc.IRPCNetworkDelegate
import com.joyy.hagorpc.internal.RPCNetworkObserver

/**
 * RPC网络状态委托默认实现
 * Created by wjh on 2021/11/4
 */
open class DefaultNetworkDelegate() : IRPCNetworkDelegate {

    private val TAG = "DefaultNetworkDelegate"

    private val mNetworkObserver: RPCNetworkObserver by lazy {
        RPCNetworkObserver()
    }

    /**
     * 开始
     */
    fun start(context: Context) {
        Log.d(TAG, "start")
        mNetworkObserver.observe(context.applicationContext)
    }

    /**
     * 停止
     */
    fun stop(context: Context) {
        Log.d(TAG, "stop")
        mNetworkObserver.cancel(context.applicationContext)
    }

    override fun isNetworkAvailable(): Boolean {
        return mNetworkObserver.isNetAvailable(null)
    }

    override fun onObserveNetwork(listener: INetworkChangeListener) {
        Log.d(TAG, "onObserveNetwork listener: ${listener.javaClass.name}")
        mNetworkObserver.addListener(listener)
    }

    override fun onRemoveObserver(listener: INetworkChangeListener) {
        Log.d(TAG, "onRemoveObserver listener: ${listener.javaClass.name}")
        mNetworkObserver.removeListener(listener)
    }
}