package com.joyy.hagorpc.impl

import android.os.Looper
import com.joyy.hagorpc.IRPCDataProvider
import com.joyy.hagorpc.RPCManager
import com.joyy.hagorpc.WsStatus
import com.joyy.hagorpc.internal.RPCConst

/**
 * 相关默认配置帮助类
 * Created by wjh on 2021/12/17
 */
object DefaultConfigHelper {

    fun isUiThread(): Boolean {
        val current = Thread.currentThread()
        val mainLooper = Looper.getMainLooper()
        if (mainLooper != null) {
            return current == mainLooper.thread
        }
        return false
    }

    fun getLanguageAndCountry(language: String?, country: String?): String {
        return (language ?: "") + "_" + (country ?: "")
    }

    fun dispatchRequestToHttp(condition: IRPCDataProvider.DispatchCondition): IRPCDataProvider.DispatchResult? {
        // 当网络不可用时，不要用短连接，而应该用长连接，
        // 因为长连接有等待机制，可保证后续恢复正常的时候能重试，提高成功率
        if (!RPCManager.isNetAvailable()) {
            return null
        }
        if (RPCManager.getStatus() != WsStatus.CONNECT_SUCCESS) {
            return IRPCDataProvider.DispatchResult(true, true)
        }
        return IRPCDataProvider.DispatchResult(condition.expectUseHttp, true)
    }

    fun getConnectTimeout(): Long {
        return RPCConst.CONNECT_TIMEOUT
    }

    fun getHeartbeatTimeout(): Long {
        return RPCConst.HEARTBEAT_TIMEOUT
    }
}