package com.joyy.hagorpc.birdge

import com.joyy.hagorpc.RPCCommonNotice
import com.joyy.hagorpc.RPCHeader
import com.joyy.hagorpc.RPCHeartBeatRes
import com.joyy.hagorpc.RPCManager
import com.joyy.hagorpc.RPCPacketV2
import com.joyy.hagorpc.RPCPacketV3
import com.joyy.hagorpc.internal.RPCHeaderExt.toHeader
import com.joyy.hagorpc.internal.RPCPacketExt.fromInnerV2
import com.joyy.hagorpc.internal.RPCPacketExt.fromInnerV3
import com.joyy.hagorpc.internal.RPCPacketExt.toInnerV2
import com.joyy.hagorpc.internal.RPCProtoHelper
import ikxd.cproxy.CProxy
import ikxd.cproxy.Uri
import ikxd.cproxy.HeartbeatReq
import ikxd.online.HeartBeatReq
import ikxd.online.IKXDOnlineProto
import net.ihago.ymicro.srv.ypush.CommonNotice

actual object RPCPacketBridge {
    actual fun toByteArray(packet: RPCPacketV2): ByteArray {
        return packet.toInnerV2().encode()
    }

    actual fun fromInnerV2(data: ByteArray): RPCPacketV2? {
        return RPCProtoHelper.parseInner(data)?.fromInnerV2()
    }

    actual fun fromInnerV3(data: ByteArray): RPCPacketV3? {
        return RPCProtoHelper.parseInnerV3(data)?.fromInnerV3()
    }

    actual fun fromCommonNotice(data: ByteArray): RPCCommonNotice {
        val result = CommonNotice.ADAPTER.decode(data)
        return RPCCommonNotice(
            sname = result.sname,
            uri = result.uri,
            payload = result.payload.toByteArray()
        )
    }

    actual fun createCProxyProto(
        gameId: String?,
        playingGameChanged: Boolean,
        header: RPCHeader.Builder
    ): ByteArray {
        val cproxy = CProxy.Builder()
            .uri(Uri.kUriHeartbeatReq)
        header.setLang(RPCManager.lang())
        val heartBeatReq = HeartbeatReq.Builder()
        if (!gameId.isNullOrEmpty()) {
            heartBeatReq.game_id(gameId)
        }
        heartBeatReq.changed(playingGameChanged)
        heartBeatReq.back_ground(header.backGround)
        return cproxy.header(header.build().toHeader()).heartbeat_req(heartBeatReq.build()).build()
            .encode()
    }

    actual fun createOnlineProto(
        gameId: String?,
        playingGameChanged: Boolean,
        header: RPCHeader.Builder,
        bizMap: Map<String, String>?
    ): ByteArray {
        val onLine = IKXDOnlineProto.Builder()
            .uri(ikxd.online.Uri.kUriHeartBeatReq)
        header.setLang(RPCManager.lang())
        val heartBeatReq = HeartBeatReq.Builder()
            .changed(playingGameChanged)
            .back_ground(header.backGround)
        if (!gameId.isNullOrEmpty()) {
            heartBeatReq.gid(gameId)
        }
        if (bizMap != null) {
            heartBeatReq.bizs(bizMap)
        }
        return onLine.header(header.build().toHeader()).heartbeat_req(heartBeatReq.build()).build()
            .encode()
    }

    actual fun heartBeatResFromCProxy(data: ByteArray): RPCHeartBeatRes {
        val heartbeatRes = CProxy.ADAPTER.decode(data).heartbeat_res
        return RPCHeartBeatRes(heartbeatRes?.next ?: 0, heartbeatRes?.timestamp ?: 0)
    }

    actual fun heartBeatResFromOnline(data: ByteArray): RPCHeartBeatRes {
        val heartbeatRes = IKXDOnlineProto.ADAPTER.decode(data).heartbeat_res
        return RPCHeartBeatRes(heartbeatRes?.next ?: 0, heartbeatRes?.timestamp ?: 0)
    }

}