package com.joyy.hagorpc.birdge

import android.annotation.SuppressLint
import android.content.Context
import android.content.SharedPreferences

@SuppressLint("StaticFieldLeak")
actual object LocalPersistenceBridge {

    private var context: Context? = null

    private val cachePreference = mutableMapOf<String, SharedPreferences>()


    fun init(context: Context) {
        this.context = context.applicationContext
    }

    actual fun getLong(name: String, key: String, defaultValue: Long): Long? {
        return getPreference(name)?.getLong(key, defaultValue)
    }

    actual fun putLong(name: String, key: String, value: Long) {
        getPreference(name)?.edit()?.putLong(key, value)?.apply()
    }

    actual fun getString(name: String, key: String, defaultValue: String): String? {
        return getPreference(name)?.getString(key, defaultValue)
    }

    actual fun putString(name: String, key: String, value: String) {
        getPreference(name)?.edit()?.putString(key, value)?.apply()
    }

    private fun getPreference(name: String): SharedPreferences? {
        val preference = cachePreference[name] ?: context?.getSharedPreferences(name, Context.MODE_PRIVATE)
        if (preference != null) {
            cachePreference[name] = preference
        }
        return preference
    }

}