package com.joyy.hagorpc.birdge

import com.joyy.hagorpc.RPCManager
import com.joyy.hagorpc.internal.RPCHttpSender

actual object HttpClientBridge {

    private val httpSender: RPCHttpSender by lazy {
        return@lazy RPCHttpSender(RPCManager.mInternalContext)
    }

    actual val TAG: String
        get() = "HttpClientBridge"

    actual enum class HttpMethod {
        GET, POST
    }

    /**
     * @param httpUrl HTTP 请求地址
     * @param method HTTP 请求类型
     * @param requestHeader 请求头部
     * @param payload 请求 Body
     * @param waitTimeout 请求总超时毫秒（包括连接 + 读取 + 写入）
     */
    actual fun send(
        httpUrl: String?,
        method: HttpMethod,
        requestHeader: Map<String, String>,
        payload: ByteArray?,
        waitTimeout: Long,
        onResponse: (responseBytes: ByteArray, responseLength: Long, responseHeader: Map<String, List<String>>) -> Unit,
        onError: (canRetry: Boolean, fromTimeout: Boolean, code: Int, msg: String, responseHeader: Map<String, List<String>>) -> Unit
    ): Boolean {
        return httpSender.send(
            httpUrl = httpUrl,
            method = method,
            requestHeader = requestHeader,
            payload = payload,
            waitTimeout = waitTimeout,
            onResponse = onResponse,
            onError = onError
        ) ?: false
    }

}