package com.joyy.hagorpc.birdge

import android.util.Base64
import com.joyy.hagorpc.internal.Base64Utils

actual object Base64Bridge {
    actual fun decode(source: String): String {
        return String(Base64Utils.decode(source, Base64Utils.NO_WRAP))
    }

    actual fun encode(source: String): String {
        return Base64.encodeToString(source.toByteArray(), Base64Utils.NO_WRAP)
    }

}