package com.joyy.hagorpc

import com.joyy.hagorpc.birdge.LoggerBridge
import com.joyy.hagorpc.birdge.RunnableBridge

/**
 * 安全的Runnable包装器（保证内部task执行的异常可被catch住）
 * Created by wjh on 2021/10/22
 */
internal class SafeRunnable(val logger: ILogger? = null, val task: RunnableBridge) : RunnableBridge {

    override fun run() {
        try {
            task.run()
        } catch (e: Throwable) {
            LoggerBridge.logE("RPC_Runnable", "run error")
        }
    }
}