package com.joyy.hagorpc

import com.joyy.hagorpc.birdge.SystemBridge

/**
 * 请求响应数据包
 * Created by wjh on 2021/10/21
 */
data class ResponseBundle(
    val protocol: RPCPacketV2, // 协议
    val responseBytes: ByteArray, // response 的数据包（原始）
    val payload: Long = 0, // 返回结果payload
    val responseTimestamp: Long = SystemBridge.currentTimeMillis(), // 收到response的时间
    val dispatchTimestamp: Long = SystemBridge.currentTimeMillis(), // 针对response开始分发的时间
    val responseHeader: Map<String, List<String>>? = null
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is ResponseBundle) return false
        if (protocol != other.protocol) return false
        if (payload != other.payload) return false
        if (responseTimestamp != other.responseTimestamp) return false
        if (responseHeader != other.responseHeader) return false
        return true
    }

    override fun hashCode(): Int {
        var result = protocol.hashCode()
        result = 31 * result + payload.hashCode()
        result = 31 * result + responseTimestamp.hashCode()
        result = 31 * result + (responseHeader?.hashCode() ?: 0)
        return result
    }
}
