package com.joyy.hagorpc

/**
 * 长连接状态
 * Created by wjh on 2021/11/2
 */
enum class WsStatus {
    CONNECT_NONE,  // 未知
    CONNECT_SUCCESS,  // 连接成功
    CONNECT_FAIL,  // 连接失败
    CONNECTING  // 正在连接
}

/**
 * 连接返回异常码
 */
object WsCode {
    /**
     * 服务端错误下线的Code
     * 不同的手机登陆:kickoff
     */
    const val KICKOFF_CODE = 4000

    //当App抢登时，不清除token，让账号登录继续可用；
    const val KICKOFF_CODE_BY_OUR_OTHER_APP = 4004

    /**
     * 服务端错误下线的Code
     * 封禁：Banned
     */
    const val BANNED_CODE = 4002

    /**
     * 服务端token解析失败
     */
    const val TOKEN_PARSE_FAIL = 4101

    /**
     * 主动关闭
     */
    const val MYSELF_CLOSE_CODE = 1000

    /**
     * 测试环境不在白名单类，无法登录
     */
    const val TEST_ENV_NOT_IN_WHITE_LIST = 4010

    /**
     * 没有token
     */
    const val NO_TOKEN = 100

    /**
     * 错误的URL
     */
    const val ERROR_URL = 101

    /**
     * 网络异常
     */
    const val NETWORK_UNAVAILABLE_CODE = -3

    /**
     * 网络导致的异常
     */
    const val NETWORK_FAILURE_CODE = -4

    /**
     * 未知错误
     */
    const val UNKNOWN_CODE = -2

    /**
     * 重连超过最大次数
     */
    const val RECONNECT_MAX_TIME = -5
}