package com.joyy.hagorpc

import com.joyy.hagorpc.birdge.RPCPacketBridge
import kotlin.jvm.JvmField

/**
 * cproxy新的解包方式
 * @param payload 业务包承载
 */
data class RPCPacketV2(
    @JvmField val header: RPCHeader,
    @JvmField val uri: Int,
    @JvmField val payload: ByteArray,
) {
    // 默认情况下，我们会将整个序列化为二进制数据，如果 toByteArray 不为 null，则使用 toByteArray 序列化
    var toByteArray: (() -> ByteArray) = { RPCPacketBridge.toByteArray(this) }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RPCPacketV2

        if (header != other.header) return false
        if (uri != other.uri) return false
        if (!payload.contentEquals(other.payload)) return false

        return true
    }


    override fun toString(): String {
        return "RPCPacket(header=$header, uri=$uri)"
    }

    override fun hashCode(): Int {
        var result = header.hashCode()
        result = 31 * result + uri
        result = 31 * result + payload.contentHashCode()
        return result
    }
}
