package com.joyy.hagorpc

import com.joyy.hagorpc.birdge.SystemBridge

/**
 * rpc请求结果结构
 * Created by wjh on 2021/10/25
 */
data class RPCCallResponse(
    /**
     * 请求的相关信息
     */
    val call: RPCCallRequest?,
    /**
     * 最终解析innerV2或innerV3协议后的payload
     */
    val payload: ByteArray = ByteArray(0),
    /**
     * 长连接回调response的数据包大小（原始）
     */
    val resLength: Long = 0,
    /**
     * 长连接回调response的时间戳
     */
    val resTimestamp: Long = SystemBridge.currentTimeMillis(),
    /**
     * 内部分发response时的时间戳
     */
    val dispatchTimestamp: Long = SystemBridge.currentTimeMillis(),
    /**
     * 请求结果的header（只有短连接才有此数据）
     */
    val responseHeader: Map<String, List<String>>?
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is RPCCallResponse) return false
        if (call != other.call) return false
        if (!payload.contentEquals(other.payload)) return false
        if (resLength != other.resLength) return false
        if (resTimestamp != other.resTimestamp) return false
        if (dispatchTimestamp != other.dispatchTimestamp) return false
        if (responseHeader != other.responseHeader) return false
        return true
    }

    override fun hashCode(): Int {
        var result = call?.hashCode() ?: 0
        result = 31 * result + payload.contentHashCode()
        result = 31 * result + resLength.hashCode()
        result = 31 * result + resTimestamp.hashCode()
        result = 31 * result + dispatchTimestamp.hashCode()
        result = 31 * result + (responseHeader?.hashCode() ?: 0)
        return result
    }

    override fun toString(): String {
        return "RPCCallResponse(call=$call, " +
                "payloadSize=${payload.size}, resLength=$resLength, " +
                "resTimestamp=$resTimestamp, dispatchTimestamp=$dispatchTimestamp, " +
                "responseHeader=$responseHeader)"
    }
}