package com.joyy.hagorpc

/**
 * rpc请求数据结构
 * Created by wjh on 2021/11/5
 */
data class RPCCallRequest(
    val url: String,
    val oldSeqId: Long, val seqId: Long,
    val sname: String, val method: String, val uri: Int,
    val requestLength: Long, val sendTimestamp: Long,
    val retryTimes: Int, val wsQueueSize: Long,
    val useHttp: Boolean = false,
    val lifeCycleTrace: String = ""
) {

    constructor(req: RPCCallRequest?, lifeCycleTrace: String) : this(
        req?.url ?: "", req?.oldSeqId ?: 0, req?.seqId ?: 0,
        req?.sname ?: "", req?.method ?: "", req?.uri ?: 0,
        req?.requestLength ?: 0, req?.sendTimestamp ?: 0,
        req?.retryTimes ?: 0, req?.wsQueueSize ?: -1,
        req?.useHttp ?: false, lifeCycleTrace
    ) {
    }

    override fun toString(): String {
        return "RPCCallRequest(url='$url', " +
                "oldSeqId=$oldSeqId, seqId=$seqId, " +
                "sname='$sname', method='$method', uri=$uri, " +
                "requestLength=$requestLength, sendTimestamp=$sendTimestamp, " +
                "retryTimes=$retryTimes, wsQueueSize=$wsQueueSize, " +
                "useHttp=$useHttp, lifeCycleTrace='$lifeCycleTrace')"
    }
}
