package com.joyy.hagorpc

import com.joyy.hagorpc.birdge.IOExceptionBridge


/**
 * rpc请求异常数据结构
 * Created by wjh on 2021/10/21
 */
class RPCCallException(
    val call: RPCCallRequest?,
    canRetry: Boolean,
    isTimeout: Boolean,
    reason: String?,
    code: Int?,
    responseHeader: Map<String, List<String>>? = null
) : IOExceptionBridge(reason) {
    // 原因
    private val mReason: String? = reason

    // 原因返回码
    private val mCode: Int? = code

    // 是否可重试
    private val mCanRetry: Boolean = canRetry

    // 是否因为超时
    private val mTimeout: Boolean = isTimeout

    private val mResponseHeader: Map<String, List<String>>? = responseHeader

    fun getReason(): String? {
        return mReason
    }

    fun getCode(): Int? {
        return mCode
    }

    fun canRetry(): Boolean {
        return mCanRetry
    }

    fun isTimeout(): Boolean {
        return mTimeout
    }

    fun getHeader(): Map<String, List<String>>? {
        return mResponseHeader
    }

    override fun toString(): String {
        return "RPCCallException(call=$call, " +
                "mReason=$mReason, mCode=$mCode, " +
                "mCanRetry=$mCanRetry, mTimeout=$mTimeout, " +
                "mResponseHeader=$mResponseHeader)"
    }
}