package com.joyy.hagorpc

import com.joyy.hagorpc.internal.RPCProtoHelper
import com.squareup.wire.AndroidMessage

/**
 * proto结果回调
 * Created by wjh on 2021/10/25
 */
internal abstract class ProtoResCallback<T : AndroidMessage<T, *>>(
    private val requestProto: T
) : IResCallback {

    override fun callbackOnUI(): Boolean {
        return false
    }

    override fun onResponse(res: RPCCallResponse) {
        val protoRes = RPCProtoHelper.parseBytes(requestProto.adapter, res.payload)
        if (protoRes == null) {
            onError(RPCCallException(res.call, false, false, "parse res payload error", WsCode.UNKNOWN_CODE, null))
        } else {
            onResponse(res, protoRes)
        }
    }

    abstract fun onResponse(res: RPCCallResponse, proto: T)

    override fun onRequest(req: RPCCallRequest) {
        // do nothing
    }

    override fun getTimeout(): Long {
        return 10000
    }
}