package com.joyy.hagorpc

/**
 * 内部广播数据包
 * Created by wjh on 2021/10/21
 */
data class NotifyBundle(val protocol: RPCPacketV2, val payload: ByteArray) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotifyBundle

        if (protocol != other.protocol) return false
        if (!payload.contentEquals(other.payload)) return false

        return true
    }

    override fun hashCode(): Int {
        var result = protocol.hashCode()
        result = 31 * result + payload.contentHashCode()
        return result
    }
}
