package com.joyy.hagorpc

/**
 * rpc请求响应回调
 * Created by wjh on 2021/10/21
 */
interface IResCallback {

    /**
     * 请求发送前回调
     */
    fun onRequest(req: RPCCallRequest)

    /**
     * 请求成功回调
     */
    fun onResponse(res: RPCCallResponse)

    /**
     * 请求失败回调，返回是否希望重试（如果error.canRetry()是false，即使返回true也不会重试）
     */
    fun onError(error: RPCCallException): Boolean

    /**
     * 默认超时
     */
    fun getTimeout(): Long

    /**
     * 是否回调在UI线程
     */
    fun callbackOnUI(): Boolean = true

    /**
     * 是否期望使用短连http请求
     */
    fun expectHttpRequest(): Boolean = false

    /**
     * 请求是否需要token
     */
    fun needToken(): Boolean = true
}