package com.joyy.hagorpc

/**
 * rpc接收者
 * Created by wjh on 2021/10/21
 */
interface IRPCReceiver {

    /**
     * 注册通知
     */
    fun register(sname: String, uri: Any?, notify: IRPCNotify)

    /**
     * 注销通知
     */
    fun unregister(sname: String, uri: Any?, notify: IRPCNotify)

    /**
     * 注册模糊通知（sname只要包含部分）
     */
    fun registerForFuzzy(sname: String, uri: Any?, notify: IRPCNotify)

    /**
     * 注销模糊通知
     */
    fun unregisterForFuzzy(sname: String, uri: Any?, notify: IRPCNotify)

    /**
     * 监听长连接状态
     */
    fun listenStatus(listener: IRPCStateListener)

    /**
     * 移出长连接状态监听
     */
    fun removeListen(listener: IRPCStateListener)
}