package com.joyy.hagorpc

/**
 * rpc网络状态相关处理委托
 * Created by wjh on 2021/11/4
 */
interface IRPCNetworkDelegate {
    /**
     * 网络是否可用
     */
    fun isNetworkAvailable(): Boolean

    /**
     * 监听网络
     */
    fun onObserveNetwork(listener: INetworkChangeListener)

    /**
     * 移出网络监听
     */
    fun onRemoveObserver(listener: INetworkChangeListener)
}

interface INetworkChangeListener {
    /**
     * 网络状态变更
     */
    fun onChange(isNetAvailable: Boolean)
}