package com.joyy.hagorpc

/**
 * 内部逻辑相关数据和状态沟通桥梁
 * Created by wjh on 2021/11/2
 */
interface IRPCInternalContext {

    fun getToken(): String
    fun getUid(): String?
    fun getNetworkClient(): INetworkClient
    fun getPingInterval(): Long
    fun getConnectTimeout(): Long
    fun getConnectRetryMax(): Int
    fun getRequestMaxRetry(): Int
    fun getCommonHeader(wsUrl: String, forWs: Boolean): Map<String, String>?
    fun useGZip(wsUrl: String): Boolean
    fun useReliableBroadcast(): Boolean
    fun enableBackgroundReconnect(wsUrl: String): Boolean
    fun getHeartbeatInfo(from: Int?): IRPCDataProvider.HeartbeatInfo
    fun getLanguage(): String?
    fun getCountry(): String?
    fun getRouteKey(service: String): String

    fun getMainExecutor(): IRPCExecutor
    fun getAsyncExecutor(): IRPCExecutor
    fun getNetworkDelegate(): IRPCNetworkDelegate
    fun getMemoryDelegate(): IRPCMemoryDelegate
    fun getEventListener(): IRPCEventListener
    fun getNotifyFrequencyDelegate(): INotifyFrequencyDelegate
    fun getLogger(): ILogger

    fun sendProtoBytes(payload: ByteArray, callback: IResCallback)

    // 更新当前长连接使用的网络库
    fun updateWsClientNetwork(url: String, network: String?)
}