package com.joyy.hagorpc

/**
 * 请求事件委托（一般用于统计和埋点）
 * Created by wjh on 2021/10/29
 */
interface IRPCEventListener {

    data class ConnectEvent(
        val code: Int,
        val reason: String?,
        val previousConnected: Boolean,
        val isFirst: Boolean,
        val connectTimes: Int,
        val consumeDuration: Long, // 触发ws成功的耗时
        val sessionId: Long,
        val sessionDuration: Long, // 整个session的耗时（从发起到成功，中间可能有多次失败）
        val detailThrowable: Throwable?
    ) {
        override fun toString(): String {
            return "ConnectEvent(code=$code, reason=$reason, " +
                    "previousConnected=$previousConnected, " +
                    "isFirst=$isFirst, connectTimes=$connectTimes, " +
                    "consumeDuration=$consumeDuration, sessionDuration=$sessionDuration, " +
                    "sessionId=$sessionId, detailThrowable=$detailThrowable)"
        }
    }

    data class HeartBeatData(
        val heartInterval: Long,
        val serverRealTime: Long,
        val clientRealTime: Long,
        val dispatchDuration: Long,
        val responseDuration: Long,
        val fromRetry: Boolean
    ) {
        override fun toString(): String {
            return "HeartBeatData(heartInterval=$heartInterval, " +
                    "serverRealTime=$serverRealTime, clientRealTime=$clientRealTime, " +
                    "dispatchDuration=$dispatchDuration, responseDuration=$responseDuration, " +
                    "fromRetry=$fromRetry)"
        }
    }

    /**
     * 长连接成功
     */
    fun onConnectSuccess(event: ConnectEvent)

    /**
     * 长连接失败
     */
    fun onConnectFail(event: ConnectEvent)

    /**
     * 定期超时行为轮询
     */
    fun onPollTimeout(consume: Long, traceString: String?)

    /**
     * 开始发起心跳行为
     */
    fun onStartHeartBeat(call: RPCCallRequest, heartInterval: Long, requestProto: Any, callFrom: Int?)

    /**
     * 心跳行为结果
     */
    fun onHeartBeatResponse(res: RPCCallResponse, data: HeartBeatData, callFrom: Int?)

    /**
     * 心跳行为失败，返回是否需要重试，fromRetry：表示是否来自重试的行为
     */
    fun onHeartBeatError(error: RPCCallException, fromRetry: Boolean, callFrom: Int?): Boolean

    /**
     * 请求生命周期开始
     */
    fun onStartRequest(call: RPCCallRequest)

    /**
     * 请求生命周期完成
     */
    fun onFinishRequest(call: RPCCallRequest)

    /**
     * innerV3协议解析失败
     */
    fun onInnerV3UnpackFail(responseTime: Long, seqId: Long)
}