package com.joyy.hagorpc

/**
 * rpc相关业务数据提供者（主要用于相关数据是会随着相关场景变更的，所以需要根据调用时获取当前最合适的数据）
 * Created by wjh on 2021/12/17
 */
interface IRPCDataProvider {

    data class DispatchCondition(
        val sName: String,
        val method: String,
        val expectUseHttp: Boolean,
        val needToken: Boolean,
        val currentWsCount: Int
    ) {
        override fun toString(): String {
            return "DispatchCondition(sName='$sName', method='$method', " +
                    "expectUseHttp=$expectUseHttp, needToken=$needToken, " +
                    "currentWsCount=$currentWsCount)"
        }
    }

    data class DispatchResult(
        val useHttp: Boolean,
        val useWaitTimeout: Boolean
    ) {
        override fun toString(): String {
            return "DispatchResult(useHttp=$useHttp, useWaitTimeout=$useWaitTimeout)"
        }
    }

    data class HeartbeatInfo(
        val useCProxy: Boolean, // 心跳协议是否采用cproxy
        val onlineBizMap: Map<String, String>?, // 心跳包携带的头部
        val requestTimeout: Long, // 心跳请求超时
        val pongTimeout: Long, // 心跳响应的超时时间（超时没收到应答，重连长连接）
        val playingGame: String? // 当前运行的游戏
    ) {

    }

    fun language(): String?

    fun country(): String?

    /**
     * 返回长连接地址
     */
    fun url(): String?

    /**
     * 返回token
     */
    fun token(): String?

    /**
     * 当前所属账号UID
     */
    fun uid(): String?

    /**
     * 返回pcid
     */
    fun pcid(): String?

    /**
     * 请求头部
     */
    fun commonHeader(wsUrl: String, forWs: Boolean): Map<String, String>?

    /**
     * 发起心跳请求的信息
     */
    fun heartbeatInfo(from: Int?): HeartbeatInfo

    /**
     * 返回routekey
     */
    fun routeKey(service: String): String?

    /**
     * 是否采用短连接请求
     */
    fun dispatchRequestToHttp(condition: DispatchCondition): DispatchResult?

    /**
     * 是否可在后台时重连长连接
     */
    fun enableBackgroundReconnect(wsUrl: String): Boolean
}