package com.joyy.hagorpc

import com.joyy.hagorpc.birdge.RunnableBridge

/**
 * 广播频度处理代理接口
 * Created by wjh on 2021/10/26
 */
interface INotifyFrequencyDelegate {
    /**
     * 返回频率控制执行器
     */
    fun createExecutor(duration: Long): IFrequencyExecutor

    /**
     * 返回频率间隔时长
     */
    fun getIntervalTime(sname: String, uri: Int): Long

    /**
     * 是否可替换当前等待广播的数据
     */
    fun canReplace(sname: String, uri: Int): Boolean

    /**
     * 是否可批量广播，返回允许同时广播的数量，当返回-1表示不允许批量，逐个广播
     */
    fun onBatch(sname: String, uri: Int): Int

    /**
     * 是否以sname维度控制
     */
    fun isControl(sname: String): Boolean

    /**
     * 是否以sname和uri维度控制
     */
    fun isControl(sname: String, uri: Int): Boolean

    /**
     * 实际处理通知之后的行为
     */
    fun onAfterNotify(
        sname: String, uriList: List<Int>,
        lastNotifyTime: Long, thisNotifyTime: Long, receiveTime: Long
    )

    /**
     * 拦截并返回最终列表
     */
    fun intercept(dataList: List<NotifyBundle>): List<NotifyBundle>
}

interface IFrequencyExecutor {
    fun execute(task: RunnableBridge)
    fun update(duration: Long)
}