package net.ihago.ymicro.srv.ypush;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.WireEnum;

/**
 * option java_package="com.yy.hiyo.proto";
 */
public enum PayloadType implements WireEnum {
    /**
     * 默认为pb格式
     */
    PAYLOAD_TYPE_PB(0),

    /**
     * json格式
     */
    PAYLOAD_TYPE_JSON(1),

    /**
     * 其他格式
     */
    PAYLOAD_TYPE_OTHER(99),

    UNRECOGNIZED(-1);

    public static final ProtoAdapter<PayloadType> ADAPTER = ProtoAdapter.newEnumAdapter(PayloadType.class);

    private final int value;

    PayloadType(int value) {
        this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static PayloadType fromValue(int value) {
        switch (value) {
            case 0:
                return PAYLOAD_TYPE_PB;
            case 1:
                return PAYLOAD_TYPE_JSON;
            case 99:
                return PAYLOAD_TYPE_OTHER;
            default:
                return UNRECOGNIZED;
        }
    }

    @Override
    public int getValue() {
        return value;
    }
}
