package net.ihago.ymicro.srv.ypush;

import com.squareup.wire.AndroidMessage;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import okio.ByteString;

/**
 * 新框架通用下行包，用于第三方非pb格式的下行透传。
 */
public final class CommonNotice extends AndroidMessage<CommonNotice, CommonNotice.Builder> {
  public static final ProtoAdapter<CommonNotice> ADAPTER = ProtoAdapter.newMessageAdapter(CommonNotice.class);

  public static final Creator<CommonNotice> CREATOR = AndroidMessage.newCreator(ADAPTER);

  private static final long serialVersionUID = 0L;

  public static final String DEFAULT_SNAME = "";

  public static final Long DEFAULT_URI = 0L;

  public static final PayloadType DEFAULT_PAYLOADTYPE = PayloadType.PAYLOAD_TYPE_PB;

  public static final ByteString DEFAULT_PAYLOAD = ByteString.EMPTY;

  @WireField(
          tag = 1,
          adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String sname;

  @WireField(
          tag = 2,
          adapter = "com.squareup.wire.ProtoAdapter#INT64"
  )
  public final Long uri;

  @WireField(
          tag = 19,
          adapter = "net.ihago.ymicro.srv.ypush.PayloadType#ADAPTER"
  )
  public final PayloadType payloadtype;

  /**
   * 对应 payloadtype 枚举类型的原始int，反序列化出来的值可以从这里取
   */
  private int _payloadtype_value = DEFAULT_PAYLOADTYPE.getValue();

  @WireField(
          tag = 20,
          adapter = "com.squareup.wire.ProtoAdapter#BYTES"
  )
  public final ByteString payload;

  private boolean __isDefaultInstance;

  public CommonNotice(String sname, Long uri, PayloadType payloadtype, int _payloadtype_value,
                      ByteString payload) {
    this(sname, uri, payloadtype, _payloadtype_value, payload, ByteString.EMPTY);
  }

  public CommonNotice(String sname, Long uri, PayloadType payloadtype, int _payloadtype_value,
                      ByteString payload, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.sname = sname;
    this.uri = uri;
    this.payloadtype = payloadtype;
    this._payloadtype_value = _payloadtype_value;
    this.payload = payload;
  }

  /**
   * 对应 payloadtype 枚举类型的原始int，反序列化出来的值可以从这里取
   */
  public final int getPayloadtypeValue() {
    return _payloadtype_value;
  }

  /**
   * true--反序列化为null，给一个默认的实例；false--反序列化出来的实例
   */
  public final boolean __isDefaultInstance() {
    return __isDefaultInstance;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.sname = sname;
    builder.uri = uri;
    builder.payloadtype = payloadtype;
    builder._payloadtype_value = _payloadtype_value;
    builder.payload = payload;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if (!(other instanceof CommonNotice)) {
      return false;
    }
    CommonNotice o = (CommonNotice) other;
    return unknownFields().equals(o.unknownFields())
            && Internal.equals(sname, o.sname)
            && Internal.equals(uri, o.uri)
            && Internal.equals(payloadtype, o.payloadtype)
            && Internal.equals(_payloadtype_value, o._payloadtype_value)
            && Internal.equals(payload, o.payload);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (sname != null ? sname.hashCode() : 0);
      result = result * 37 + (uri != null ? uri.hashCode() : 0);
      result = result * 37 + (payloadtype != null ? payloadtype.hashCode() : 0);
      result = result * 37 + _payloadtype_value;
      result = result * 37 + (payload != null ? payload.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  public static final class Builder extends Message.Builder<CommonNotice, Builder> {
    public String sname;

    public long uri;

    public PayloadType payloadtype;

    private int _payloadtype_value;

    public ByteString payload;

    public Builder() {
    }

    public Builder sname(String sname) {
      this.sname = sname;
      return this;
    }

    public Builder uri(Long uri) {
      this.uri = uri;
      return this;
    }

    public Builder payloadtype(PayloadType payloadtype) {
      this.payloadtype = payloadtype;
      if (payloadtype != PayloadType.UNRECOGNIZED) {
        _payloadtype_value = payloadtype.getValue();
      }
      return this;
    }

    public Builder payload(ByteString payload) {
      this.payload = payload;
      return this;
    }

    @Override
    public CommonNotice build() {
      return new CommonNotice(sname, uri, payloadtype, _payloadtype_value, payload, super.buildUnknownFields());
    }
  }
}
