/*
 * Decompiled with CFR 0.152.
 */
package com.hydra._internal;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LoadLibraryUtils {
    private static final String TAG = "Hydra-LoadLibraryUtils";

    public static boolean loadLibrary(Context context, String libName) {
        Log.i((String)TAG, (String)String.format("load library: %s", libName));
        try {
            System.loadLibrary(libName);
            Log.i((String)TAG, (String)String.format("load library: %s success", libName));
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)String.format("System.loadLibrary %s failed:%s", libName, e.getMessage()));
            if (Build.VERSION.SDK_INT >= 24) {
                Log.e((String)TAG, (String)String.format("load(libfullname,classloader) or loadLibrary(libfullname,classloader) disabled!!!", libName));
                return false;
            }
            boolean ret = LoadLibraryUtils.load(context, libName, context.getClassLoader());
            if (ret) {
                Log.i((String)TAG, (String)String.format("load library: %s success", libName));
            } else {
                Log.e((String)TAG, (String)String.format("load library: %s failed", libName));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(Context context, String libName, ClassLoader classLoader) {
        File libFile;
        File libFilev7a;
        File nativePathFile = new File(context.getApplicationInfo().nativeLibraryDir);
        String libPath = null;
        if ("armeabi-v7a".equals(Build.CPU_ABI) && (libFilev7a = new File(nativePathFile, "lib" + libName + "-v7a.so")).exists()) {
            File libFileRecover = new File(context.getDir("lib_v7a", 0), "lib" + libName + ".so");
            if (!libFileRecover.exists() || libFilev7a.length() != libFileRecover.length()) {
                LoadLibraryUtils.copy(libFilev7a, libFileRecover);
            }
            if (libFileRecover.exists() && libFileRecover.length() == libFilev7a.length()) {
                libPath = libFileRecover.getAbsolutePath();
            }
        }
        if (libPath == null && (libFile = new File(nativePathFile, "lib" + libName + ".so")).exists()) {
            libPath = libFile.getAbsolutePath();
        }
        if (libPath != null && LoadLibraryUtils.load(libPath, classLoader)) {
            Log.i((String)TAG, (String)(libPath + " loaded"));
            return true;
        }
        if (LoadLibraryUtils.loadLibrary(libName, classLoader)) {
            Log.i((String)TAG, (String)(libName + " loaded"));
            return true;
        }
        ZipFile apkZipFile = null;
        try {
            File libFile2 = new File(context.getDir("lib_ext", 0), "lib" + libName + ".so");
            File apkFile = new File(context.getApplicationInfo().sourceDir);
            apkZipFile = new ZipFile(apkFile);
            if (LoadLibraryUtils.copy(apkZipFile, libName, libFile2) && libFile2.length() > 0L && LoadLibraryUtils.load(libFile2.getAbsolutePath(), classLoader)) {
                Log.i((String)TAG, (String)(libFile2.getAbsolutePath() + " loaded"));
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)("load failed:" + t.getMessage()));
        }
        finally {
            try {
                if (apkZipFile != null) {
                    apkZipFile.close();
                }
            }
            catch (Throwable t) {
                return false;
            }
        }
        Log.e((String)TAG, (String)(libName + " load failed"));
        return false;
    }

    private static boolean load(String libPath, ClassLoader classLoader) {
        try {
            Runtime rt = Runtime.getRuntime();
            Method method = rt.getClass().getDeclaredMethod("load", String.class, ClassLoader.class);
            method.setAccessible(true);
            method.invoke((Object)rt, libPath, classLoader);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)("Fail to load library:" + e.getTargetException().getMessage()));
            return false;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)("Fail to load library:" + t.getMessage()));
            return false;
        }
        return true;
    }

    private static boolean loadLibrary(String libName, ClassLoader classLoader) {
        try {
            Runtime rt = Runtime.getRuntime();
            Method method = rt.getClass().getDeclaredMethod("loadLibrary", String.class, ClassLoader.class);
            method.setAccessible(true);
            method.invoke((Object)rt, libName, classLoader);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)("Fail to load library:" + e.getTargetException().getMessage()));
            return false;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)("Fail to load library:" + t.getMessage()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File oldfile, File newFile) {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            if (newFile.exists()) {
                newFile.delete();
            }
            if (oldfile.exists()) {
                byte[] buffer = new byte[2048];
                int byteread = 0;
                is = new FileInputStream(oldfile);
                os = new FileOutputStream(newFile);
                while ((byteread = is.read(buffer)) != -1) {
                    os.write(buffer, 0, byteread);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Fail to load library:" + e.getMessage()));
            newFile.delete();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Fail to load library:" + e.getMessage()));
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Fail to load library:" + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy(ZipFile apkZipFile, String libName, File saveFile) {
        ZipEntry libEntry = null;
        if ("armeabi-v7a".equals(Build.CPU_ABI) && (libEntry = apkZipFile.getEntry("lib/armeabi-v7a/lib" + libName + ".so")) == null) {
            libEntry = apkZipFile.getEntry("lib/armeabi/lib" + libName + "-v7a.so");
        }
        if (libEntry == null) {
            libEntry = apkZipFile.getEntry("lib/armeabi/lib" + libName + ".so");
        }
        if (libEntry == null) {
            return false;
        }
        if (libEntry.getSize() == saveFile.length()) {
            return true;
        }
        if (saveFile.exists()) {
            saveFile.delete();
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = apkZipFile.getInputStream(libEntry);
            os = new FileOutputStream(saveFile);
            byte[] buffer = new byte[2048];
            int byteread = 0;
            while ((byteread = is.read(buffer)) != -1) {
                os.write(buffer, 0, byteread);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)("Fail to load library:" + t.getMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Fail to load library:" + e.getMessage()));
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Fail to load library:" + e.getMessage()));
            }
        }
        return false;
    }
}

