/*
 * Decompiled with CFR 0.152.
 */
package com.hydra._internal;

import com.hydra.Code;
import com.hydra.Data;
import com.hydra.DigitGroup;
import com.hydra.Hydra;
import com.hydra.Message;
import com.hydra.ServiceId;
import com.hydra.Token;
import java.util.HashMap;
import java.util.List;

public class HydraJNIProxy {
    public static Hydra.State state = Hydra.State.Unavailable;

    public static void setLogger(Hydra.Logger logger) {
        HydraJNIProxy.setLogger(new LoggerProxy(logger));
    }

    public static native int jniInit(long var0, String var2);

    public static native int jniDeinit();

    public static native void jniAddDelegate(Object var0);

    public static native void jniRemoveDelegate(Object var0);

    public static native void jniLogin(long var0, Token.Provider var2, CompletionProxy var3);

    public static native void jniLogout();

    public static native void jniSetupGSLB(Object var0);

    public static native long jniRPC(ServiceId var0, Message var1, RPCCompletionProxy var2);

    public static native void jniSubscribe(List<String> var0);

    public static native void jniUnsubscribe(List<String> var0);

    public static native void jniSubscribeDGroups(List<DigitGroup> var0);

    public static native void jniUnsubscribeDGroups(List<DigitGroup> var0);

    public static native void addHydraListener(HydraListenerProxy var0);

    public static native void removeHydraListener(HydraListenerProxy var0);

    public static native void setLogger(LoggerProxy var0);

    public static native long getLastServerAcceptTs();

    public static native long getSyncedTimestamp();

    public static interface HydraListenerProxy {
        public void onRecv(String var1, String var2, String var3, HashMap<String, String> var4, String var5, byte[] var6);

        public void onRecv(String var1, String var2, String var3, String var4, HashMap<String, String> var5, String var6, byte[] var7);

        public void onRecv(String var1, String var2, long var3, long var5, String var7, HashMap<String, String> var8, String var9, byte[] var10);
    }

    public static class RPCCompletionProxy {
        private ServiceId serviceId;
        private Message requestMessage;
        private Hydra.RPCCompletion completion;

        public RPCCompletionProxy(ServiceId serviceId, Message requestMessage, Hydra.RPCCompletion completion) {
            this.serviceId = serviceId;
            this.requestMessage = requestMessage;
            this.completion = completion;
        }

        public void onRPCComplete(long requestId, int code, String codeInfo, String context, HashMap<String, String> headers, String proto, byte[] data) {
            if (code == 200) {
                Message message = null;
                if (data != null) {
                    message = new Message(context, null, new Data(proto, data));
                }
                this.completion.onSuccess(requestId, this.serviceId, message);
            } else {
                this.completion.onFailed(requestId, this.serviceId, new Code(code, codeInfo), this.requestMessage);
            }
        }
    }

    public static class CompletionProxy {
        private Hydra.Completion completion;

        public CompletionProxy(Hydra.Completion completion) {
            this.completion = completion;
        }

        void onComplete(int code, String desc) {
            if (code == 200) {
                this.completion.onSuccess();
            } else {
                this.completion.onFailed(new Code(code, desc));
            }
        }
    }

    public static class LoggerProxy {
        Hydra.Logger logger;

        public LoggerProxy(Hydra.Logger logger) {
            this.logger = logger;
        }

        public void log(int level, String msg) {
            int logLevel = 4;
            if (level == 0) {
                logLevel = 2;
            } else if (level == 1) {
                logLevel = 3;
            } else if (level == 2) {
                logLevel = 4;
            } else if (level == 3) {
                logLevel = 5;
            } else if (level == 4) {
                logLevel = 6;
            }
            this.logger.log(logLevel, msg);
        }
    }

    public static interface DelegateProxy {
        public void onStateChange(int var1, int var2);

        public void onConnectionChange(int var1);

        public void onKickoff(int var1, String var2);
    }
}

