/*
 * Decompiled with CFR 0.152.
 */
package com.hydra._internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.hydra.Hydra;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.HttpDnsService;
import java.util.UUID;

public class GSLBProxy {
    static GSLBProxy instance = new GSLBProxy();
    private SharedPreferences sharedPref;
    private String hdid;
    private DnsResultInfo mDnsResult = null;
    private static HttpDnsService mGSLB = null;

    public static GSLBProxy getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] hdid() {
        if (this.hdid != null) {
        }
        this.hdid = this.sharedPref.getString("hdid", "");
        try {
            if (this.hdid.isEmpty()) {
                String tmpUuid = UUID.randomUUID().toString();
                this.hdid = tmpUuid.replace("-", "");
                this.storeHdId();
            }
        }
        finally {
            return this.hdid.getBytes();
        }
    }

    public String[] dnsResolve(byte[] host) {
        if (Hydra.lbsServerIP != null) {
            return new String[]{Hydra.lbsServerIP};
        }
        String[] ips = new String[]{};
        if (this.mDnsResult == null || this.mDnsResult.mIps == null || this.mDnsResult.mIps.length == 0) {
            DnsResultInfo info = mGSLB.getIpsByHost(new String(host), true);
            if (info != null && info.mIps != null) {
                ips = info.mIps;
            }
        } else {
            ips = this.mDnsResult.mIps;
        }
        this.mDnsResult = mGSLB.getIpsByHostAsync(new String(host));
        return ips;
    }

    public String[] dnsStoreLoad() {
        if (Hydra.lbsServerIP != null) {
            return new String[]{Hydra.lbsServerIP};
        }
        String lbsips = this.sharedPref.getString("ipskey", "");
        if (lbsips == null || lbsips.isEmpty()) {
            String[] ips = new String[]{};
            return ips;
        }
        String[] splitips = lbsips.split("\\|");
        return splitips;
    }

    public int dnsStoreFlush(String[] ips) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < ips.length; ++i) {
            stringBuilder.append(ips[i]);
            stringBuilder.append("|");
        }
        SharedPreferences.Editor editor = this.sharedPref.edit();
        editor.putString("ipskey", stringBuilder.toString());
        boolean ret = editor.commit();
        if (!ret) {
            return -1;
        }
        return 0;
    }

    private void storeHdId() {
        if (this.hdid == null || this.hdid.isEmpty()) {
            return;
        }
        SharedPreferences.Editor editor = this.sharedPref.edit();
        editor.putString("hdid", this.hdid);
        editor.commit();
    }

    public void init(Context appContext, long appId) {
        if (mGSLB != null) {
            return;
        }
        this.sharedPref = appContext.getSharedPreferences(String.valueOf(appId) + "hydra", 0);
        mGSLB = HttpDnsService.getService();
        this.dnsAsync();
    }

    private void dnsAsync() {
        this.mDnsResult = mGSLB.getIpsByHostAsync(new String("aplbs.service.huanjuyun.com"));
    }
}

