/*
 * Decompiled with CFR 0.152.
 */
package com.hydra;

import android.content.Context;
import android.util.Log;
import com.hydra.Code;
import com.hydra.DigitGroup;
import com.hydra.Message;
import com.hydra.ServiceId;
import com.hydra.Token;
import com.hydra._internal.GSLBProxy;
import com.hydra._internal.HydraDelegateHolders;
import com.hydra._internal.HydraJNIProxy;
import com.hydra._internal.HydraListenerHolders;
import com.hydra._internal.LoadLibraryUtils;
import com.yy.gslbsdk.HttpDnsService;
import java.util.List;

public class Hydra {
    private static final String TAG = "Hydra";
    public static String lbsServerIP = null;
    private static Hydra hydra = new Hydra();
    private static boolean firstInit = true;

    public static synchronized void loadLib(Context appContext) {
        if (!LoadLibraryUtils.loadLibrary(appContext, "hydra")) {
            Log.e((String)TAG, (String)"load hydra failed");
        }
    }

    public static int init(Context appContext, long appId, String appVersion) {
        Hydra.setupGSLB(appContext, appId);
        if (firstInit) {
            HydraJNIProxy.jniAddDelegate(HydraDelegateHolders.getInstance());
        }
        int ret = HydraJNIProxy.jniInit(appId, appVersion);
        if (firstInit) {
            HydraJNIProxy.addHydraListener(HydraListenerHolders.getInstance());
        }
        firstInit = false;
        return ret;
    }

    public static int deInit() {
        return HydraJNIProxy.jniDeinit();
    }

    public static void addDelegate(Delegate delegate) {
        HydraDelegateHolders.getInstance().addDelegate(delegate);
    }

    public static void removeDelegate(Delegate delegate) {
        HydraDelegateHolders.getInstance().removeDelegate(delegate);
    }

    public static void login(long uid, Token.Provider tokenProvider, Completion completion) {
        HydraJNIProxy.jniLogin(uid, tokenProvider, new HydraJNIProxy.CompletionProxy(completion));
    }

    public static void logout() {
        HydraJNIProxy.jniLogout();
    }

    public static State getState() {
        return HydraJNIProxy.state;
    }

    public static void setupGSLB(Context appContext, long appId) {
        if (HttpDnsService.getService() == null) {
            HttpDnsService.getService((Context)appContext, (String)"servicesdk", null, (String)"", (String)"");
        }
        GSLBProxy gslbProxy = GSLBProxy.getInstance();
        gslbProxy.init(appContext, appId);
        HydraJNIProxy.jniSetupGSLB(gslbProxy);
    }

    public static void setLogger(Logger l) {
        HydraJNIProxy.setLogger(l);
    }

    public static long syncedCurrentTimestamp() {
        return HydraJNIProxy.getSyncedTimestamp();
    }

    public static long getLastServerAcceptTs() {
        return HydraJNIProxy.getLastServerAcceptTs();
    }

    public static void setLBSServerIP(String argLbsServerIP) {
        lbsServerIP = argLbsServerIP;
    }

    public static Hydra hydra() {
        return hydra;
    }

    public long rpc(ServiceId serviceId, Message message, RPCCompletion completion) {
        return HydraJNIProxy.jniRPC(serviceId, message, new HydraJNIProxy.RPCCompletionProxy(serviceId, message, completion));
    }

    public void subscribeStrGroups(List<String> groups) {
        HydraJNIProxy.jniSubscribe(groups);
    }

    public void subscribeDigitGroups(List<DigitGroup> groups) {
        HydraJNIProxy.jniSubscribeDGroups(groups);
    }

    public void unsubscribeStrGroups(List<String> groups) {
        HydraJNIProxy.jniUnsubscribe(groups);
    }

    public void unsubscribeDigitGroups(List<DigitGroup> groups) {
        HydraJNIProxy.jniUnsubscribeDGroups(groups);
    }

    public void addListener(Listener listener) {
        HydraListenerHolders.getInstance().addListener(listener);
    }

    public void removeListener(Listener listener) {
        HydraListenerHolders.getInstance().removeListener(listener);
    }

    private Hydra() {
    }

    public static interface Listener {
        public void onRecv(ServiceId var1, Message var2);

        public void onRecv(ServiceId var1, String var2, Message var3);

        public void onRecv(ServiceId var1, DigitGroup var2, Message var3);
    }

    public static interface RPCCompletion {
        public void onSuccess(long var1, ServiceId var3, Message var4);

        public void onFailed(long var1, ServiceId var3, Code var4, Message var5);
    }

    public static interface Completion {
        public void onSuccess();

        public void onFailed(Code var1);
    }

    public static interface Logger {
        public void log(int var1, String var2);
    }

    public static interface Delegate {
        public void onStateChanged(State var1, State var2);

        public void onConnectionChanged(ConnectionState var1);

        public void onKickoff(int var1, String var2);
    }

    public static enum ConnectionState {
        Disconnected,
        Connecting,
        Connected;

    }

    public static enum State {
        Unavailable,
        Connecting,
        Anonymous,
        LoggingIn,
        LogedIn;

    }
}

