package com.hummer.im.signal._internals.rpc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.Signal;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;

/**
 * 查询用户在线状态
 */
public class RPCQueryUserState extends IMRPC<
        Signal.CheckUserIsOnlineRequest,
        Signal.CheckUserIsOnlineRequest.Builder,
        Signal.CheckUserIsOnlineResponse> {

    private final User mUser;
    private final RichCompletionArg<Boolean> completion;

    public RPCQueryUserState(User user, RichCompletionArg<Boolean> completion) {
        this.mUser = user;
        this.completion = completion;
    }

    @Override
    public void buildHummerRequest(@NonNull Signal.CheckUserIsOnlineRequest.Builder builder) {
        builder.setUid(mUser.getId());
    }

    @Override
    public void handleHummerSuccess(@NonNull Signal.CheckUserIsOnlineResponse res) {
        CompletionUtils.dispatchSuccess(this.completion, res.getIsOnline());
    }

    @Override
    public void handleHummerError(@Nullable Signal.CheckUserIsOnlineResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }

    @Override
    public String getHummerFunction() {
        return "CheckUserIsOnline";
    }

    @Override
    public String describeHummerRequest(Signal.CheckUserIsOnlineRequest req) {
        return new StringChain().acceptNullElements().add("user", mUser).toString();
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }
}
