package com.hummer.im.signal;

import android.support.annotation.NonNull;

import com.hummer.im.HMR;
import com.hummer.im.model.signal.Message;
import com.hummer.im.model.signal.SendingOptions;
import com.hummer.im.model.id.User;

public interface SignalService {

    /**
     * 用于查询用户在线，可以查询具体用户是否在线
     *
     * @param user       需要查询是否在线的用户
     * @param completion 该操作的异步回调
     */
    void queryOnlineStatusForUser(User user, HMR.CompletionArg<Boolean> completion);

    /**
     * 发送P2P信令消息
     *
     * @param message    需要发送的信令消息
     * @param toUser     信令消息的接受者标识
     * @param options    发送消息所需要的配置信息
     * @param completion 发送操作的完成回调
     */
    void send(@NonNull final Message message,
              @NonNull final User toUser,
              @NonNull SendingOptions options,
              @NonNull final HMR.Completion completion);

    interface Listener {

        /**
         * 当收到信令消息时，会收到该事件的通知回调
         *
         * @param message  收到的信令消息
         * @param fromUser 发送者的标识
         */
        void onReceivedMessage(Message message, User fromUser);
    }

    /**
     * 添加信令消息的监听器
     *
     * @param listener 需要添加的监听器
     */
    void addListener(Listener listener);

    /**
     * 移除信令消息的监听器
     *
     * @param listener 需要移除的监听器
     */
    void removeListener(Listener listener);
}
