/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.relation.friend._internals;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.channel.Channel;
import com.hummer.im.db.DBService;
import com.hummer.im.id.User;
import com.hummer.im.relation.friend.FriendService;
import com.hummer.im.relation.friend._internals.FriendlistNotifyMsg;
import com.hummer.im.relation.friend._internals.MQFriendlistNtfyMsgParser;
import com.hummer.im.relation.friend._internals.RPCAddFriend;
import com.hummer.im.relation.friend._internals.RPCGetFriendList;
import com.hummer.im.relation.friend._internals.RPCRemoveFriend;
import com.hummer.im.shared.DispatchQueue;
import com.hummer.im.shared.ServiceProvider;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class FriendlistServiceImpl
implements MQService.MQSubscriber,
FriendService {
    public static final String TAG = "FriendService";
    private final Set<FriendService.FriendListener> friendObservers = new HashSet<FriendService.FriendListener>();
    private final Set<User> cachedFriends = new HashSet<User>();

    public Class[] staticDependencies() {
        return new Class[]{MQService.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{Channel.class, DBService.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[]{MQService.class};
    }

    public void initService() {
        ((MQService)HMR.getService(MQService.class)).registerMsgParser((MQService.MsgParser)new MQFriendlistNtfyMsgParser());
    }

    public void openService(@NonNull Completion completion) {
        ((MQService)HMR.getService(MQService.class)).addSubscriber((MQService.MQSubscriber)this);
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCGetFriendList((CompletionArg<List<User>>)new CompletionArg().onSuccess(list -> {
            this.cachedFriends.addAll((Collection<User>)list);
            this.notifyUpdateFriendList((List<User>)list);
        })));
        CompletionUtils.dispatchSuccess((Completion)completion);
    }

    public void closeService() {
        this.cachedFriends.clear();
        ((MQService)HMR.getService(MQService.class)).removeSubscriber((MQService.MQSubscriber)this);
    }

    @Override
    public void listFriends(CompletionArg<List<User>> completionArg) {
        CompletionUtils.dispatchSuccess(completionArg, new ArrayList<User>(this.cachedFriends));
    }

    @Override
    public void isFriend(User user, CompletionArg<Boolean> completionArg) {
        CompletionUtils.dispatchSuccess(completionArg, (Object)this.cachedFriends.contains(user));
    }

    @Override
    public void addFriend(User user, String string, CompletionArg<RPCAddFriend.Response> completionArg) {
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCAddFriend(user, string, (CompletionArg<RPCAddFriend.Response>)new CompletionArg().onSuccess(response -> CompletionUtils.dispatchSuccess((CompletionArg)completionArg, (Object)response)).onFailure(error -> CompletionUtils.dispatchFailure((CompletionArg)completionArg, (Error)error))));
    }

    @Override
    public void removeFriend(User user, String string, CompletionArg<String> completionArg) {
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCRemoveFriend(user, string, completionArg));
    }

    public boolean shouldReceiveMessage(HMR.Message message) {
        return message instanceof FriendlistNotifyMsg.NotifyFriendBuddyAddedMsg || message instanceof FriendlistNotifyMsg.NotifyFriendBuddyDeletedMsg;
    }

    public void onReceiveMessage(HMR.Message message) {
        Log.i((String)TAG, (Object)message);
        HMRContext.work.async(() -> this.processNotificationMessage(message));
    }

    private void processNotificationMessage(HMR.Message message) {
        if (message instanceof FriendlistNotifyMsg.NotifyFriendBuddyAddedMsg) {
            FriendlistNotifyMsg.NotifyFriendBuddyAddedMsg notifyFriendBuddyAddedMsg = (FriendlistNotifyMsg.NotifyFriendBuddyAddedMsg)message;
            this.cachedFriends.add(notifyFriendBuddyAddedMsg.getBuddy());
            DispatchQueue.main.async(() -> {
                this.notifyFriendAdded(notifyFriendBuddyAddedMsg.getBuddy());
                this.notifyUpdateFriendList(new ArrayList<User>(this.cachedFriends));
            });
        } else if (message instanceof FriendlistNotifyMsg.NotifyFriendBuddyDeletedMsg) {
            FriendlistNotifyMsg.NotifyFriendBuddyDeletedMsg notifyFriendBuddyDeletedMsg = (FriendlistNotifyMsg.NotifyFriendBuddyDeletedMsg)message;
            this.cachedFriends.remove(notifyFriendBuddyDeletedMsg.getBuddy());
            DispatchQueue.main.async(() -> {
                this.notifyFriendRemoved(notifyFriendBuddyDeletedMsg.getBuddy());
                this.notifyUpdateFriendList(new ArrayList<User>(this.cachedFriends));
            });
        }
    }

    @Override
    public void addFriendListener(FriendService.FriendListener friendListener) {
        HMRContext.work.async(() -> {
            this.friendObservers.add(friendListener);
            Log.i((String)TAG, (Object)Trace.once().method("addListener").info("listener", (Object)friendListener.getClass().getSimpleName()).info("size", (Object)this.friendObservers.size()));
        });
    }

    @Override
    public void removeFriendListener(FriendService.FriendListener friendListener) {
        HMRContext.work.async(() -> {
            this.friendObservers.remove(friendListener);
            Log.i((String)TAG, (Object)Trace.once().method("addListener").info("listener", (Object)friendListener.getClass().getSimpleName()).info("size", (Object)this.friendObservers.size()));
        });
    }

    private void notifyUpdateFriendList(@NonNull List<User> list) {
        for (FriendService.FriendListener friendListener : this.friendObservers) {
            friendListener.onUpdateFriends(list);
        }
    }

    private void notifyFriendAdded(User user) {
        for (FriendService.FriendListener friendListener : this.friendObservers) {
            friendListener.onAddedFriend(user);
        }
    }

    private void notifyFriendRemoved(User user) {
        for (FriendService.FriendListener friendListener : this.friendObservers) {
            friendListener.onRemoveFriend(user);
        }
    }
}

