/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.relation.blacklist._internals;

import com.hummer.im.HMR;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im._internals.proto.BuddyOuterClass;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im.id.User;
import com.hummer.im.relation.blacklist._internals.BlacklistNotifyMsg;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

public class MQBlacklistNtfyMsgParser
implements MQService.MsgParser {
    public static final String TAG = "MQBlacklistNtfyMsgParser";

    public List<Im.Action> getActions() {
        return Arrays.asList(Im.Action.kNotifyBlacklistAddedRequest, Im.Action.kNotifyBlacklistRemovedRequest);
    }

    public HMR.Message parse(Pull.Msg msg) {
        if (msg.getAction() == Im.Action.kNotifyBlacklistAddedRequest) {
            return this.parseBlacklistAddMsg(msg);
        }
        return this.parseBlacklistRemoveMsg(msg);
    }

    private BlacklistNotifyMsg parseBlacklistAddMsg(Pull.Msg msg) {
        Assert.assertEquals((Object)Im.Action.kNotifyBlacklistAddedRequest, (Object)msg.getAction());
        BuddyOuterClass.NotifyBlacklistAddedRequest notifyBlacklistAddedRequest = (BuddyOuterClass.NotifyBlacklistAddedRequest)((BuddyOuterClass.NotifyBlacklistAddedRequest.Builder)BuddyOuterClass.NotifyBlacklistAddedRequest.newBuilder().mergeFrom(msg.getChatContent())).build();
        return new BlacklistNotifyMsg(true, new User(notifyBlacklistAddedRequest.getInitiateUid()), new User(notifyBlacklistAddedRequest.getAddedUid()));
    }

    private BlacklistNotifyMsg parseBlacklistRemoveMsg(Pull.Msg msg) {
        Assert.assertEquals((Object)Im.Action.kNotifyBlacklistRemovedRequest, (Object)msg.getAction());
        BuddyOuterClass.NotifyBlacklistRemovedRequest notifyBlacklistRemovedRequest = (BuddyOuterClass.NotifyBlacklistRemovedRequest)((BuddyOuterClass.NotifyBlacklistRemovedRequest.Builder)BuddyOuterClass.NotifyBlacklistRemovedRequest.newBuilder().mergeFrom(msg.getChatContent())).build();
        return new BlacklistNotifyMsg(false, new User(notifyBlacklistRemovedRequest.getInitiateUid()), new User(notifyBlacklistRemovedRequest.getRemovedUid()));
    }

    public String toString() {
        return TAG;
    }
}

