/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.relation.blacklist._internals;

import android.support.annotation.NonNull;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.channel.Channel;
import com.hummer.im.id.Identifiable;
import com.hummer.im.id.User;
import com.hummer.im.relation.blacklist.BlacklistService;
import com.hummer.im.relation.blacklist._internals.BlacklistNotifyMsg;
import com.hummer.im.relation.blacklist._internals.MQBlacklistNtfyMsgParser;
import com.hummer.im.relation.blacklist._internals.RPCBlockUser;
import com.hummer.im.relation.blacklist._internals.RPCGetBlackList;
import com.hummer.im.relation.blacklist._internals.RPCUnblockUser;
import com.hummer.im.services.user.UserService;
import com.hummer.im.shared.DispatchQueue;
import com.hummer.im.shared.ServiceProvider;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;

public final class BlacklistServiceImpl
implements MQService.MQSubscriber,
BlacklistService {
    private static final String TAG = "BlacklistService";
    private final Set<User> blockedUsers = new HashSet<User>();
    private final Set<BlacklistService.BlacklistListener> observers = new HashSet<BlacklistService.BlacklistListener>();

    public Class[] staticDependencies() {
        return new Class[]{MQService.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, Channel.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[]{MQService.class};
    }

    public void initService() {
        ((MQService)HMR.getService(MQService.class)).registerMsgParser((MQService.MsgParser)new MQBlacklistNtfyMsgParser());
    }

    public void openService(@NonNull Completion completion) {
        ((MQService)HMR.getService(MQService.class)).addSubscriber((MQService.MQSubscriber)this);
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCGetBlackList((CompletionArg<List<User>>)new CompletionArg().onSuccess(list -> {
            this.blockedUsers.addAll((Collection<User>)list);
            this.notifyBlacklistChanged();
        })));
        CompletionUtils.dispatchSuccess((Completion)completion);
    }

    public void closeService() {
        this.blockedUsers.clear();
        ((MQService)HMR.getService(MQService.class)).removeSubscriber((MQService.MQSubscriber)this);
    }

    @Override
    public void listBlacklist(CompletionArg<List<User>> completionArg) {
        CompletionUtils.dispatchSuccess(completionArg, new ArrayList<User>(this.blockedUsers));
    }

    @Override
    public void isInBlacklist(@NonNull User user, CompletionArg<Boolean> completionArg) {
        CompletionUtils.dispatchSuccess(completionArg, (Object)this.blockedUsers.contains(user));
    }

    @Override
    public void block(@NonNull User user, @NonNull Completion completion) {
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCBlockUser(user, completion.beforeSuccess(() -> this.blockUser(user))));
    }

    @Override
    public void unblock(@NonNull User user, @NonNull Completion completion) {
        ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCUnblockUser(user, completion.beforeSuccess(() -> this.unblockUser(user))));
    }

    @Override
    public void addListener(@NonNull BlacklistService.BlacklistListener blacklistListener) {
        HMRContext.work.async(() -> {
            this.observers.add(blacklistListener);
            Log.i((String)TAG, (Object)Trace.once().method("addListener").info("listener", (Object)blacklistListener.getClass().getSimpleName()).info("size", (Object)this.observers.size()));
        });
    }

    @Override
    public void removeListener(@NonNull BlacklistService.BlacklistListener blacklistListener) {
        HMRContext.work.async(() -> {
            this.observers.remove(blacklistListener);
            Log.i((String)TAG, (Object)Trace.once().method("removeListener").info("listener", (Object)blacklistListener.getClass().getSimpleName()).info("size", (Object)this.observers.size()));
        });
    }

    public boolean shouldReceiveMessage(HMR.Message message) {
        return message instanceof BlacklistNotifyMsg;
    }

    public void onReceiveMessage(HMR.Message message) {
        Assert.assertTrue((boolean)(message instanceof BlacklistNotifyMsg));
        BlacklistNotifyMsg blacklistNotifyMsg = (BlacklistNotifyMsg)message;
        Log.i((String)TAG, (Object)Trace.once().method("onReceiveMessage").info("isAdding", (Object)blacklistNotifyMsg.isAdding).info("initiator", (Object)blacklistNotifyMsg.initiator).info("target", (Object)blacklistNotifyMsg.target));
        HMRContext.work.async(() -> this.processNotificationMessage(blacklistNotifyMsg));
    }

    private void processNotificationMessage(BlacklistNotifyMsg blacklistNotifyMsg) {
        if (blacklistNotifyMsg.isAdding) {
            if (Identifiable.equals((Identifiable)blacklistNotifyMsg.initiator, (Identifiable)HMR.getMe())) {
                this.blockUser(blacklistNotifyMsg.target);
            } else {
                this.notifyBlockedBy(blacklistNotifyMsg.initiator);
            }
        } else if (Identifiable.equals((Identifiable)blacklistNotifyMsg.initiator, (Identifiable)HMR.getMe())) {
            this.unblockUser(blacklistNotifyMsg.target);
        } else {
            this.notifyUnblockedBy(blacklistNotifyMsg.initiator);
        }
    }

    private void notifyBlacklistChanged() {
        DispatchQueue.main.async(() -> {
            for (BlacklistService.BlacklistListener blacklistListener : this.observers) {
                blacklistListener.onUpdateBlacklist(new ArrayList<User>(this.blockedUsers));
            }
        });
    }

    private void notifyBlockedBy(User user) {
        DispatchQueue.main.async(() -> {
            for (BlacklistService.BlacklistListener blacklistListener : this.observers) {
                blacklistListener.onBlockedByUser(user);
            }
        });
    }

    private void notifyUnblockedBy(User user) {
        DispatchQueue.main.async(() -> {
            for (BlacklistService.BlacklistListener blacklistListener : this.observers) {
                blacklistListener.onUnblockedByUser(user);
            }
        });
    }

    private void blockUser(User user) {
        if (!this.blockedUsers.add(user)) {
            return;
        }
        DispatchQueue.main.async(() -> {
            for (BlacklistService.BlacklistListener blacklistListener : this.observers) {
                blacklistListener.onBlockUser(user);
            }
        });
        this.notifyBlacklistChanged();
    }

    private void unblockUser(User user) {
        if (!this.blockedUsers.remove(user)) {
            return;
        }
        DispatchQueue.main.async(() -> {
            for (BlacklistService.BlacklistListener blacklistListener : this.observers) {
                blacklistListener.onUnblockUser(user);
            }
        });
        this.notifyBlacklistChanged();
    }
}

