/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.relation.backlog._internals;

import com.hummer.im._internals.log.Log;
import com.hummer.im.relation.backlog.BacklogService;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.Serializable;

@DatabaseTable(tableName="relation_backlogs")
public class BeanRelationBacklog
implements Serializable {
    static final String relationName = "relation";
    static final String requestName = "request";
    static final String responseName = "response";
    @DatabaseField(id=true, columnName="relation", unique=true)
    String relation;
    @DatabaseField(columnName="request")
    String request;
    @DatabaseField(columnName="response")
    String response;
    private static final String TAG = "BeanRelationBacklog";

    public static BeanRelationBacklog fromBacklog(BacklogService.Backlog backlog) {
        try {
            BeanRelationBacklog beanRelationBacklog = new BeanRelationBacklog();
            beanRelationBacklog.relation = BacklogService.Relation.makeString(backlog.getRelation());
            beanRelationBacklog.request = BacklogService.RelationRequest.makeString(backlog.getRequest());
            beanRelationBacklog.response = BacklogService.RelationResponse.makeString(backlog.getResponse());
            return beanRelationBacklog;
        }
        catch (BacklogService.BacklogServiceException backlogServiceException) {
            Log.e((String)TAG, (Object)backlogServiceException.getLocalizedMessage());
            return null;
        }
    }

    public static BacklogService.Backlog toBacklog(BeanRelationBacklog beanRelationBacklog) {
        try {
            BacklogService.Relation relation = BacklogService.Relation.makeRelation(beanRelationBacklog.relation);
            BacklogService.RelationRequest relationRequest = BacklogService.RelationRequest.makeRequest(beanRelationBacklog.request);
            BacklogService.RelationResponse relationResponse = BacklogService.RelationResponse.makeResponse(beanRelationBacklog.response);
            return new BacklogService.Backlog(relation, relationRequest, relationResponse);
        }
        catch (BacklogService.BacklogServiceException backlogServiceException) {
            Log.e((String)TAG, (Object)backlogServiceException.getLocalizedMessage());
            return null;
        }
    }

    public String toString() {
        return TAG;
    }
}

