/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.relation.backlog._internals;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQService;
import com.hummer.im.channel.Channel;
import com.hummer.im.db.DBActions;
import com.hummer.im.db.DBService;
import com.hummer.im.id.Identifiable;
import com.hummer.im.id.User;
import com.hummer.im.relation.backlog.BacklogService;
import com.hummer.im.relation.backlog._internals.BeanRelationBacklog;
import com.hummer.im.relation.backlog._internals.FriendRelationNotifyMsg;
import com.hummer.im.relation.backlog._internals.MQFriendRelationNtfyMsgParser;
import com.hummer.im.relation.backlog._internals.RPCAcceptAddFriend;
import com.hummer.im.relation.backlog._internals.RPCRejectAddFriend;
import com.hummer.im.services.user.UserService;
import com.hummer.im.shared.DispatchQueue;
import com.hummer.im.shared.ServiceProvider;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import com.hummer.im.shared.completion.CompletionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

public final class BacklogServiceImpl
implements MQService.MQSubscriber,
BacklogService {
    private static final String TAG = "BacklogService";
    private final Set<BacklogService.Listener> relationObservers = new HashSet<BacklogService.Listener>();
    private final Map<String, BacklogService.Backlog> relationToBacklog = new HashMap<String, BacklogService.Backlog>();

    public Class[] staticDependencies() {
        return new Class[]{MQService.class};
    }

    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, DBService.class};
    }

    public Class[] plantingDynamicDependencies() {
        return new Class[]{MQService.class};
    }

    public void initService() {
        ((MQService)HMR.getService(MQService.class)).registerMsgParser((MQService.MsgParser)new MQFriendRelationNtfyMsgParser());
    }

    public void openService(@NonNull Completion completion) {
        ((MQService)HMR.getService(MQService.class)).addSubscriber((MQService.MQSubscriber)this);
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().createTableIfNeeded(BeanRelationBacklog.class).run("Completion", () -> CompletionUtils.dispatchSuccess((Completion)completion)));
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().queryAll(BeanRelationBacklog.class, list -> {
            LinkedList<BacklogService.Backlog> linkedList = new LinkedList<BacklogService.Backlog>();
            for (BeanRelationBacklog beanRelationBacklog : list) {
                BacklogService.Backlog backlog = BeanRelationBacklog.toBacklog(beanRelationBacklog);
                linkedList.addFirst(backlog);
                this.relationToBacklog.put(BacklogService.Relation.makeString(backlog.getRelation()), backlog);
            }
            this.notifyUpdateBacklogList(linkedList);
        }));
    }

    public void closeService() {
        this.relationToBacklog.clear();
        ((MQService)HMR.getService(MQService.class)).removeSubscriber((MQService.MQSubscriber)this);
    }

    @Override
    public void listBacklogs(CompletionArg<List<BacklogService.Backlog>> completionArg) {
        CompletionUtils.dispatchSuccess(completionArg, new ArrayList<BacklogService.Backlog>(this.relationToBacklog.values()));
    }

    private void relationChangeNotify() {
        this.listBacklogs((CompletionArg<List<BacklogService.Backlog>>)new CompletionArg(new Handler(Looper.getMainLooper())).onSuccess(this::notifyUpdateBacklogList));
    }

    @Override
    public void removeBacklog(BacklogService.Backlog backlog) {
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().deleteById(BeanRelationBacklog.class, (Object)BacklogService.Relation.makeString(backlog.getRelation())));
        this.relationToBacklog.remove(BacklogService.Relation.makeString(backlog.getRelation()));
        DispatchQueue.main.async(() -> {
            this.notifyRemoveBacklog(backlog);
            this.relationChangeNotify();
        });
    }

    @Override
    public void respondBacklog(BacklogService.RelationRequest relationRequest, BacklogService.RelationResponse.Action action, String string, Completion completion) {
        Identifiable identifiable = relationRequest.relation.owner;
        User user = relationRequest.relation.user;
        if (!Identifiable.equals((Identifiable)identifiable, (Identifiable)HMR.getMe()) || Identifiable.equals((Identifiable)identifiable, (Identifiable)user)) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1002, "Invalid owner or try friend-ing your self"));
            return;
        }
        if (relationRequest.token == null) {
            CompletionUtils.dispatchFailure((Completion)completion, (Error)new Error(1002, "Invalid request, the token is null"));
        }
        Assert.assertTrue((action == BacklogService.RelationResponse.Action.Accept || action == BacklogService.RelationResponse.Action.Reject ? 1 : 0) != 0);
        if (action == BacklogService.RelationResponse.Action.Accept) {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCAcceptAddFriend(user, string, relationRequest.token, new Completion().onFailure(error -> CompletionUtils.dispatchFailure((Completion)completion, (Error)error)).onSuccess(() -> CompletionUtils.dispatchSuccess((Completion)completion))));
        } else {
            ((Channel)ServiceProvider.get(Channel.class)).run((Channel.RPC)new RPCRejectAddFriend(user, string, relationRequest.token, new Completion().onSuccess(() -> CompletionUtils.dispatchSuccess((Completion)completion)).onFailure(error -> CompletionUtils.dispatchFailure((Completion)completion, (Error)error))));
        }
    }

    public boolean shouldReceiveMessage(HMR.Message message) {
        return message instanceof FriendRelationNotifyMsg.FriendRequestNotifyMsg || message instanceof FriendRelationNotifyMsg.AcceptFriendRequestNotifyMsg || message instanceof FriendRelationNotifyMsg.RejectFriendRequestNotifyMsg;
    }

    public void onReceiveMessage(HMR.Message message) {
        Log.i((String)TAG, (Object)message);
        HMRContext.work.async(() -> this.processNotificationMessage(message));
    }

    private void processNotificationMessage(HMR.Message message) {
        if (message instanceof FriendRelationNotifyMsg.FriendRequestNotifyMsg) {
            FriendRelationNotifyMsg.FriendRequestNotifyMsg friendRequestNotifyMsg = (FriendRelationNotifyMsg.FriendRequestNotifyMsg)message;
            BacklogService.Relation relation = new BacklogService.Relation((Identifiable)friendRequestNotifyMsg.target, friendRequestNotifyMsg.applicant);
            BacklogService.Backlog backlog = this.backlogForRelation(relation);
            backlog.setRequest(new BacklogService.RelationRequest(relation, friendRequestNotifyMsg.getExtension(), friendRequestNotifyMsg.getToken()));
            backlog.setResponse(null);
            this.insertOrUpdateBacklogDB(backlog);
        } else if (message instanceof FriendRelationNotifyMsg.AcceptFriendRequestNotifyMsg) {
            FriendRelationNotifyMsg.AcceptFriendRequestNotifyMsg acceptFriendRequestNotifyMsg = (FriendRelationNotifyMsg.AcceptFriendRequestNotifyMsg)message;
            BacklogService.Relation relation = new BacklogService.Relation((Identifiable)acceptFriendRequestNotifyMsg.decider, acceptFriendRequestNotifyMsg.applicant);
            BacklogService.Backlog backlog = this.backlogForRelation(relation);
            backlog.setResponse(new BacklogService.RelationResponse(relation, acceptFriendRequestNotifyMsg.decider, BacklogService.RelationResponse.Action.Accept, acceptFriendRequestNotifyMsg.getExtension()));
            this.insertOrUpdateBacklogDB(backlog);
        } else if (message instanceof FriendRelationNotifyMsg.RejectFriendRequestNotifyMsg) {
            FriendRelationNotifyMsg.RejectFriendRequestNotifyMsg rejectFriendRequestNotifyMsg = (FriendRelationNotifyMsg.RejectFriendRequestNotifyMsg)message;
            BacklogService.Relation relation = new BacklogService.Relation((Identifiable)rejectFriendRequestNotifyMsg.decider, rejectFriendRequestNotifyMsg.applicant);
            BacklogService.Backlog backlog = this.backlogForRelation(relation);
            backlog.setResponse(new BacklogService.RelationResponse(relation, rejectFriendRequestNotifyMsg.decider, BacklogService.RelationResponse.Action.Reject, rejectFriendRequestNotifyMsg.getExtension()));
            this.insertOrUpdateBacklogDB(backlog);
        }
    }

    @Override
    public void addListener(BacklogService.Listener listener) {
        HMRContext.work.async(() -> {
            this.relationObservers.add(listener);
            Log.d((String)TAG, (Object)Trace.once().method("addListener").info("listener", (Object)listener.getClass().getSimpleName()).info("size", (Object)this.relationObservers.size()));
        });
    }

    @Override
    public void removeListener(BacklogService.Listener listener) {
        HMRContext.work.async(() -> {
            this.relationObservers.remove(listener);
            Log.d((String)TAG, (Object)Trace.once().method("addListener").info("listener", (Object)listener.getClass().getSimpleName()).info("size", (Object)this.relationObservers.size()));
        });
    }

    private void insertOrUpdateBacklogDB(BacklogService.Backlog backlog) {
        Boolean[] booleanArray = new Boolean[1];
        ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().queryById(BeanRelationBacklog.class, (Object)BacklogService.Relation.makeString(backlog.getRelation()), beanRelationBacklog -> {
            if (beanRelationBacklog == null) {
                booleanArray[0] = true;
                ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().create((Object)BeanRelationBacklog.fromBacklog(backlog), null));
            } else {
                booleanArray[0] = false;
                ((DBService)HMR.getService(DBService.class)).execute((DBService.Action)new DBActions().update((Object)BeanRelationBacklog.fromBacklog(backlog), null));
            }
        }).run(() -> DispatchQueue.main.async(() -> {
            if (booleanArray[0].booleanValue()) {
                this.notifyAddBacklog(backlog);
            } else {
                this.notifyUpdateBacklog(backlog);
            }
            this.relationChangeNotify();
        })));
    }

    private void notifyAddBacklog(BacklogService.Backlog backlog) {
        for (BacklogService.Listener listener : this.relationObservers) {
            listener.onAddBacklog(backlog);
        }
    }

    private void notifyUpdateBacklog(BacklogService.Backlog backlog) {
        for (BacklogService.Listener listener : this.relationObservers) {
            listener.onUpdateBacklog(backlog);
        }
    }

    private void notifyRemoveBacklog(BacklogService.Backlog backlog) {
        for (BacklogService.Listener listener : this.relationObservers) {
            listener.onRemoveBacklog(backlog);
        }
    }

    private void notifyUpdateBacklogList(List<BacklogService.Backlog> list) {
        for (BacklogService.Listener listener : this.relationObservers) {
            listener.onUpdateBacklogList(list);
        }
    }

    private BacklogService.Backlog backlogForRelation(BacklogService.Relation relation) {
        BacklogService.Backlog backlog = this.relationToBacklog.get(BacklogService.Relation.makeString(relation));
        if (backlog == null) {
            backlog = new BacklogService.Backlog(relation, null, null);
            this.relationToBacklog.put(BacklogService.Relation.makeString(relation), backlog);
        }
        return backlog;
    }
}

