/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.relation.backlog;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.hummer.im.HMR;
import com.hummer.im.id.IDFactory;
import com.hummer.im.id.Identifiable;
import com.hummer.im.id.User;
import com.hummer.im.shared.completion.Completion;
import com.hummer.im.shared.completion.CompletionArg;
import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import org.json.JSONException;
import org.json.JSONObject;

public interface BacklogService
extends HMR.Service {
    public void listBacklogs(CompletionArg<List<Backlog>> var1);

    public void removeBacklog(Backlog var1);

    public void respondBacklog(RelationRequest var1, RelationResponse.Action var2, String var3, Completion var4);

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public static final class Backlog
    implements HMR.Message {
        private Relation relation;
        private RelationRequest request;
        private RelationResponse response;

        public Backlog(@NonNull Relation relation, @Nullable RelationRequest relationRequest, @Nullable RelationResponse relationResponse) {
            this.relation = relation;
            this.request = relationRequest;
            this.response = relationResponse;
        }

        public State getState() {
            if (this.response == null) {
                return State.Pending;
            }
            if (this.response.action == RelationResponse.Action.Accept) {
                return State.Accepted;
            }
            return State.Rejected;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void setRelation(Relation relation) {
            this.relation = relation;
        }

        public RelationRequest getRequest() {
            return this.request;
        }

        public void setRequest(RelationRequest relationRequest) {
            this.request = relationRequest;
        }

        public RelationResponse getResponse() {
            return this.response;
        }

        public void setResponse(RelationResponse relationResponse) {
            this.response = relationResponse;
        }

        public static enum State {
            Pending,
            Accepted,
            Rejected;

        }
    }

    public static final class RelationResponse {
        public final Relation relation;
        public final Action action;
        public final User responder;
        public final String appExtra;

        public RelationResponse(Relation relation, User user, Action action, String string) {
            this.relation = relation;
            this.responder = user;
            this.action = action;
            this.appExtra = string;
        }

        public static String makeString(RelationResponse relationResponse) {
            if (relationResponse == null) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("relation", (Object)Relation.makeString(relationResponse.relation));
                jSONObject.put("appExtra", (Object)relationResponse.appExtra);
                jSONObject.put("action", (Object)RelationResponse.makeActionString(relationResponse.action));
                jSONObject.put("responder", (Object)IDFactory.toString((Identifiable)relationResponse.responder));
                return jSONObject.toString();
            }
            catch (JSONException jSONException) {
                throw new BacklogServiceException("RelationResponse makeString exception");
            }
        }

        public static RelationResponse makeResponse(String string) {
            if (string == null) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                Relation relation = Relation.makeRelation(jSONObject.getString("relation"));
                String string2 = jSONObject.getString("appExtra");
                Action action = RelationResponse.makeActionObject(jSONObject.getString("action"));
                User user = (User)IDFactory.fromString((String)jSONObject.getString("responder"));
                return new RelationResponse(relation, user, action, string2);
            }
            catch (JSONException jSONException) {
                throw new BacklogServiceException("RelationResponse makeResponse exception");
            }
        }

        private static String makeActionString(Action action) {
            if (action == Action.Accept) {
                return "accept";
            }
            if (action == Action.Reject) {
                return "reject";
            }
            Assert.fail((String)("Unsupported Action: " + (Object)((Object)action)));
            return null;
        }

        private static Action makeActionObject(String string) {
            if ("accept".equals(string = string.toLowerCase())) {
                return Action.Accept;
            }
            if ("reject".equals(string)) {
                return Action.Reject;
            }
            return null;
        }

        public static enum Action {
            Accept,
            Reject;

        }
    }

    public static final class RelationRequest {
        public final Relation relation;
        public final String appExtra;
        public final byte[] token;

        public RelationRequest(Relation relation, String string, byte[] byArray) {
            this.relation = relation;
            this.appExtra = string;
            this.token = byArray;
        }

        public static String makeString(RelationRequest relationRequest) {
            if (relationRequest == null) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("relation", (Object)Relation.makeString(relationRequest.relation));
                jSONObject.put("appExtra", (Object)relationRequest.appExtra);
                if (relationRequest.token == null) {
                    jSONObject.put("tokenbase64", (Object)"");
                } else {
                    jSONObject.put("tokenbase64", (Object)Base64.encodeToString((byte[])relationRequest.token, (int)0));
                }
                return jSONObject.toString();
            }
            catch (JSONException jSONException) {
                throw new BacklogServiceException("RelationRequest makeString exception");
            }
        }

        public static RelationRequest makeRequest(String string) {
            if (string == null) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                Relation relation = Relation.makeRelation(jSONObject.getString("relation"));
                String string2 = jSONObject.getString("appExtra");
                String string3 = jSONObject.getString("tokenbase64");
                if (string3 == "") {
                    return new RelationRequest(relation, string2, null);
                }
                byte[] byArray = Base64.decode((String)string3, (int)0);
                return new RelationRequest(relation, string2, byArray);
            }
            catch (JSONException jSONException) {
                throw new BacklogServiceException("RelationRequest makeRequest exception");
            }
        }
    }

    public static final class Relation {
        public final Identifiable owner;
        public final User user;

        public Relation(Identifiable identifiable, User user) {
            Assert.assertNotNull((Object)identifiable);
            Assert.assertNotNull((Object)user);
            this.owner = identifiable;
            this.user = user;
        }

        public static String makeString(Relation relation) {
            if (relation == null) {
                return null;
            }
            return String.format(Locale.US, "%s/%s", IDFactory.toString((Identifiable)relation.owner), IDFactory.toString((Identifiable)relation.user));
        }

        public static Relation makeRelation(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            String[] stringArray = string.split("/");
            Identifiable identifiable = IDFactory.fromString((String)stringArray[0]);
            User user = (User)IDFactory.fromString((String)stringArray[1]);
            if (identifiable == null || user == null) {
                return null;
            }
            return new Relation(identifiable, user);
        }
    }

    public static final class BacklogServiceException
    extends Exception {
        public BacklogServiceException(String string) {
            super(string);
        }
    }

    public static interface Listener {
        default public void onAddBacklog(Backlog backlog) {
        }

        default public void onUpdateBacklog(Backlog backlog) {
        }

        default public void onRemoveBacklog(Backlog backlog) {
        }

        default public void onUpdateBacklogList(List<Backlog> list) {
        }
    }
}

