/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.db;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.db.DBService;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.util.ArrayList;
import java.util.List;

public final class DBActions
implements DBService.Action {
    private List<DBService.Action> commands = new ArrayList<DBService.Action>();

    public <T> DBActions create(final @NonNull T t, final DatabaseTableConfig<T> databaseTableConfig) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                daoSet.create(databaseTableConfig, t.getClass()).create(t);
            }

            public String toString() {
                String string = "Create | model: " + t;
                if (databaseTableConfig != null) {
                    string = string + ", table: " + databaseTableConfig.getTableName();
                }
                return string;
            }
        });
        return this;
    }

    public <T> DBActions createIfNotExists(final @NonNull T t, final DatabaseTableConfig<T> databaseTableConfig) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                daoSet.create(databaseTableConfig, t.getClass()).createIfNotExists(t);
            }

            public String toString() {
                String string = "createIfNotExists | model: " + t;
                if (databaseTableConfig != null) {
                    string = string + ", table: " + databaseTableConfig.getTableName();
                }
                return string;
            }
        });
        return this;
    }

    public <T> DBActions delete(final @NonNull T t, final DatabaseTableConfig<T> databaseTableConfig) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                daoSet.create(databaseTableConfig, t.getClass()).delete(t);
            }

            public String toString() {
                String string = "Delete | model: " + t;
                if (databaseTableConfig != null) {
                    string = string + ", table: " + databaseTableConfig.getTableName();
                }
                return string;
            }
        });
        return this;
    }

    public <T, I> DBActions deleteById(final @NonNull Class<T> clazz, final @NonNull I i) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                Dao dao = daoSet.create(null, clazz);
                dao.deleteById(i);
            }

            public String toString() {
                return "DeleteById | modelClass: " + clazz.getSimpleName() + ", id: " + i;
            }
        });
        return this;
    }

    public <T, I> DBActions deleteById(final @NonNull DatabaseTableConfig<T> databaseTableConfig, final @NonNull I i) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                Dao dao = daoSet.create(databaseTableConfig, null);
                dao.deleteById(i);
            }

            public String toString() {
                return "DeleteById | table: " + databaseTableConfig.getTableName() + ", id: " + i;
            }
        });
        return this;
    }

    public <T> DBActions deleteAll(final @NonNull Class<T> clazz) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                TableUtils.clearTable((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (Class)clazz);
            }

            public String toString() {
                return "DeleteAll | modelClass: " + clazz.getSimpleName();
            }
        });
        return this;
    }

    public <T> DBActions deleteAll(final @NonNull DatabaseTableConfig<T> databaseTableConfig) {
        if (databaseTableConfig.getTableName() == null) {
            Log.e((String)"DBActions", (Object)Trace.once().method("deleteAll").info("\u4f7f\u7528tableConfigs\u8fdb\u884c\u6570\u636e\u6e05\u9664\u65f6\uff0c\u5fc5\u987b\u4e3a\u5176\u6307\u5b9a\u6570\u636e\u8868\u540d", null));
        }
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                TableUtils.clearTable((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (DatabaseTableConfig)databaseTableConfig);
            }

            public String toString() {
                return "DeleteAll | table: " + databaseTableConfig.getTableName();
            }
        });
        return this;
    }

    public <T> DBActions queryAll(final @NonNull Class<T> clazz, final @NonNull QueryAcceptor queryAcceptor) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                List list = daoSet.create(null, clazz).queryForAll();
                queryAcceptor.onQueryResults(list);
            }

            public String toString() {
                return "QueryAll | modelClass: " + clazz.getSimpleName();
            }
        });
        return this;
    }

    public <T> DBActions queryAll(final @NonNull DatabaseTableConfig<T> databaseTableConfig, final @NonNull QueryAcceptor queryAcceptor) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                List list = daoSet.create(databaseTableConfig, null).queryForAll();
                queryAcceptor.onQueryResults(list);
            }

            public String toString() {
                return "QueryAll | table: " + databaseTableConfig;
            }
        });
        return this;
    }

    public <T, ID> DBActions queryById(final @NonNull Class<T> clazz, final @NonNull ID ID, final @NonNull QueryOneAcceptor queryOneAcceptor) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                Dao dao = daoSet.create(null, clazz);
                queryOneAcceptor.onQueryResult(dao.queryForId(ID));
            }

            public String toString() {
                return "QueryById | modelClass: " + clazz.getSimpleName() + ", id: " + ID;
            }
        });
        return this;
    }

    public <T, ID> DBActions queryById(final @NonNull DatabaseTableConfig<T> databaseTableConfig, final @NonNull ID ID, final @NonNull QueryOneAcceptor queryOneAcceptor) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                Dao dao = daoSet.create(databaseTableConfig, null);
                queryOneAcceptor.onQueryResult(dao.queryForId(ID));
            }

            public String toString() {
                return "QueryById | table: " + databaseTableConfig.getTableName() + ", id: " + ID;
            }
        });
        return this;
    }

    public <T> DBActions update(final @NonNull T t, final DatabaseTableConfig<T> databaseTableConfig) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                daoSet.create(databaseTableConfig, t.getClass()).update(t);
            }

            public String toString() {
                String string = "Update | model: " + t;
                if (databaseTableConfig != null) {
                    string = string + ", table: " + databaseTableConfig.getTableName();
                }
                return string;
            }
        });
        return this;
    }

    public <T> DBActions createTableIfNeeded(final @NonNull Class<T> clazz) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                TableUtils.createTableIfNotExists((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (Class)clazz);
                DaoManager.clearDaoCache();
                daoSet.create(null, clazz);
            }

            public String toString() {
                return "CreateTableIfNeeded | modelClass: " + clazz.getSimpleName();
            }
        });
        return this;
    }

    public <T> DBActions createTableIfNeeded(final @NonNull DatabaseTableConfig<T> databaseTableConfig) {
        if (databaseTableConfig.getTableName() == null) {
            Log.e((String)"DBActions", (Object)Trace.once().method("createTableIfNeeded").info("\u4f7f\u7528tableConfigs\u65b0\u5efa\u6570\u636e\u8868\u65f6\uff0c\u5fc5\u987b\u4e3a\u5176\u6307\u5b9a\u6570\u636e\u8868\u540d", null));
        }
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                TableUtils.createTableIfNotExists((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (DatabaseTableConfig)databaseTableConfig);
                DaoManager.clearDaoCache();
                daoSet.create(databaseTableConfig, null);
            }

            public String toString() {
                return "CreateTableIfNeeded | table: " + databaseTableConfig.getTableName();
            }
        });
        return this;
    }

    public <T> DBActions dropTableIfExist(final @NonNull Class<T> clazz) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                TableUtils.dropTable((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (Class)clazz, (boolean)true);
                DaoManager.clearDaoCache();
                daoSet.remove(null, clazz);
            }

            public String toString() {
                return "DropTableIfExist | modelClass: " + clazz.getSimpleName();
            }
        });
        return this;
    }

    public <T> DBActions dropTableIfExist(final @NonNull DatabaseTableConfig<T> databaseTableConfig) {
        if (databaseTableConfig.getTableName() == null) {
            Log.e((String)"DBActions", (Object)Trace.once().method("dropTableIfExist").info("\u4f7f\u7528tableConfigs\u79fb\u9664\u6570\u636e\u8868\u65f6\uff0c\u5fc5\u987b\u4e3a\u5176\u6307\u5b9a\u6570\u636e\u8868\u540d", null));
        }
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                TableUtils.dropTable((ConnectionSource)ormLiteSqliteOpenHelper.getConnectionSource(), (DatabaseTableConfig)databaseTableConfig, (boolean)true);
                DaoManager.clearDaoCache();
                daoSet.remove(databaseTableConfig, null);
            }

            public String toString() {
                return "DropTableIfExist | table: " + databaseTableConfig.getTableName();
            }
        });
        return this;
    }

    public DBActions custom(@NonNull DBService.Action action) {
        this.commands.add(action);
        return this;
    }

    public DBActions guard(final Error error, final @NonNull Guarder guarder) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                if (guarder.shouldBreak()) {
                    throw new DBService.BreakByGuard(error);
                }
            }

            public String toString() {
                return "Guard";
            }
        });
        return this;
    }

    public DBActions run(final @NonNull Runnable runnable) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                runnable.run();
            }

            public String toString() {
                return "Custom";
            }
        });
        return this;
    }

    public DBActions run(final String string, final @NonNull Runnable runnable) {
        this.commands.add(new DBService.Action(){

            @Override
            public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
                runnable.run();
            }

            public String toString() {
                return string;
            }
        });
        return this;
    }

    @Override
    public void process(OrmLiteSqliteOpenHelper ormLiteSqliteOpenHelper, DBService.DaoSet daoSet) {
        for (DBService.Action action : this.commands) {
            action.process(ormLiteSqliteOpenHelper, daoSet);
        }
    }

    public String toString() {
        if (this.commands.size() == 1) {
            return this.commands.get(0).toString();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DBService.Action action : this.commands) {
            arrayList.add("{" + action.toString() + "}");
        }
        return "DBActions{" + TextUtils.join((CharSequence)", ", arrayList) + '}';
    }

    public static interface Guarder {
        public boolean shouldBreak();
    }

    public static interface QueryOneAcceptor<R> {
        public void onQueryResult(R var1);
    }

    public static interface QueryAcceptor<R> {
        public void onQueryResults(List<R> var1);
    }
}

