package com.hummer.im.db;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im.model.completion.RichCompletion;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.table.DatabaseTableConfig;

import java.sql.SQLException;

public interface DBService {

    interface DaoSet {
        <T> Dao<T, ?> create(DatabaseTableConfig<T> tableConfig, Class<T> modelClass) throws SQLException;

        /**
         * 移除某个非必要的dao
         * <p>
         * 该操作不是必须的，但通过调用该方法来进行dao移除，可以帮助内部优化内存占用
         */
        <T> void remove(DatabaseTableConfig<T> tableConfig, Class<T> modelClass);
    }

    class BreakByGuard extends SQLException {
        public final Error err;

        BreakByGuard(Error err) {
            this.err = err;
        }
    }

    interface Action {
        void process(OrmLiteSqliteOpenHelper helper, DaoSet daoSet) throws SQLException;
    }

    <Act extends Action> void execute(@NonNull Act act);

    <Act extends Action> void execute(@NonNull Act act, @Nullable RichCompletion completion);

    int getOldVersion();
    int getNewVersion();
}
