/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.completion;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccessArg;

public final class RichCompletionArg<T> {
    private static final String TAG = "RichCompletionArg";
    private static final String DesPrefix = "RichCompletionArg::";
    private final DispatchQueue dispatchQueue;
    private OnFailure failureHandler;
    private OnSuccessArg<T> successHandler;
    private String description;

    public RichCompletionArg(@NonNull String string) {
        Looper looper = Looper.myLooper();
        if (looper == Looper.getMainLooper()) {
            this.dispatchQueue = new DispatchQueue(new DispatchQueue.LooperHandlerProvider(Looper.getMainLooper()));
            Log.i(TAG, Trace.once().method("CompletionArgInit").info("main dispatchQueue", this.dispatchQueue));
        } else if (looper == HMRContext.work.getHandler().getLooper()) {
            this.dispatchQueue = HMRContext.work;
            Log.i(TAG, Trace.once().method("CompletionArgInit").info("work dispatchQueue", this.dispatchQueue));
        } else {
            this.dispatchQueue = DispatchQueue.direct;
            Log.i(TAG, Trace.once().method("CompletionArgInit").info("internal dispatchQueue", this.dispatchQueue));
        }
        this.description = DesPrefix + string;
        HMRContext.recorder.start("[async]" + this.description);
    }

    public RichCompletionArg(final HMR.CompletionArg<T> completionArg, @NonNull String string) {
        this(string);
        this.onSuccess(new OnSuccessArg<T>(){

            @Override
            public void onSuccess(T t) {
                if (completionArg != null) {
                    completionArg.onSuccess(t);
                }
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                if (completionArg != null) {
                    completionArg.onFailed(error);
                }
            }
        });
    }

    public RichCompletionArg(@NonNull Handler handler, @NonNull String string) {
        this.dispatchQueue = new DispatchQueue(new DispatchQueue.LooperHandlerProvider(handler.getLooper()));
        this.description = DesPrefix + string;
        HMRContext.recorder.start("[async]" + this.description);
        Log.i(TAG, Trace.once().method("CompletionArgInit").info("custom dispatchQueue with handler", this.dispatchQueue));
    }

    public RichCompletionArg<T> onSuccess(@NonNull OnSuccessArg<T> onSuccessArg) {
        this.successHandler = onSuccessArg;
        return this;
    }

    public RichCompletionArg<T> onFailure(@NonNull OnFailure onFailure) {
        this.failureHandler = onFailure;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    void dispatchSuccess(@NonNull T t) {
        Log.d(TAG, Trace.once().method("dispatchSuccess").info("dispatchQueue", this.dispatchQueue));
        final T t2 = t;
        this.dispatchQueue.async(this.description, new Runnable(){

            @Override
            public void run() {
                Log.i(RichCompletionArg.TAG, Trace.once().method("dispatchSuccess").msg("dispatchQueue async, run"));
                if (RichCompletionArg.this.successHandler != null) {
                    RichCompletionArg.this.successHandler.onSuccess(t2);
                } else {
                    Log.i(RichCompletionArg.TAG, Trace.once().method("dispatchSuccess").msg("dispatchQueue async, success handler = null"));
                }
            }
        });
    }

    void dispatchFailure(@NonNull Error error) {
        Log.i(TAG, Trace.once().method("dispatchFailure").info("result", error.toString()).info("dispatchQueue", this.dispatchQueue));
        final Error error2 = error;
        this.dispatchQueue.async(this.description, new Runnable(){

            @Override
            public void run() {
                if (RichCompletionArg.this.failureHandler != null) {
                    Log.i(RichCompletionArg.TAG, Trace.once().method("dispatchFailure").info("result", error2.toString()));
                    RichCompletionArg.this.failureHandler.onFailure(error2);
                } else {
                    Log.i(RichCompletionArg.TAG, Trace.once().method("dispatchFailure").msg("dispatchQueue async, failure handler = null"));
                }
            }
        });
    }
}

