/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.util.Patterns;
import android.webkit.URLUtil;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.services.upload.Uploader;
import com.hummer.im._internals.services.upload.YYaliOSS.AliOSS;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.FileUtils;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im._internals.shared.statis.Util;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.service.UploadService;
import org.json.JSONObject;

public final class Image
extends Content
implements Content.Preparable {
    public final int width;
    public final int height;
    public String originUrl;
    public String thumbUrl;
    private static final String TAG = "Image";

    public static Image createImage(@NonNull String string) {
        if (Patterns.WEB_URL.matcher(string).matches() || URLUtil.isValidUrl((String)string)) {
            Log.w(TAG, Trace.once().method("createImage").msg("Create url Image").info("path", string));
            return new Image(string, 0, 0);
        }
        if (!FileUtils.exists(string)) {
            Log.w(TAG, Trace.once().method("createImage").msg("Image not exists").info("path", string));
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            Log.w(TAG, Trace.once().method("createImage").msg("Not an image"));
            return null;
        }
        return new Image(string, options.outWidth, options.outHeight);
    }

    @Override
    public void prepare(final Content.PreparingCallback preparingCallback) {
        if (this.isWebImageUrl()) {
            preparingCallback.onPrepareSuccess();
            return;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)this.originUrl, (BitmapFactory.Options)options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            Log.w(TAG, Trace.once().method("createImage").msg("Not an image"));
            DispatchQueue.main.async("Image::createImageFail", new Runnable(){

                @Override
                public void run() {
                    preparingCallback.onPrepareFailed(new Error(1002, "Not an image"));
                }
            });
            return;
        }
        final BitmapFactory.Options options2 = options;
        HMR.getService(UploadService.class).uploadFile(this.originUrl, new Uploader.UploadCallback<String>(){

            @Override
            public void onSuccess(String string) {
                Image.this.originUrl = string;
                UploadService uploadService = HMR.getService(UploadService.class);
                if (uploadService.getUploader() instanceof AliOSS) {
                    int n = 300;
                    String string2 = null;
                    if (options2.outWidth > n || options2.outHeight > n) {
                        string2 = uploadService.getUploader().acquireThumbImageUrl(string, n, n);
                    }
                    if (string2 == null) {
                        string2 = string;
                    }
                    Image.this.thumbUrl = string2;
                }
                preparingCallback.onPrepareSuccess();
            }

            @Override
            public void onProgress(float f) {
                preparingCallback.onPrepare(new Preparing.ScalarProgress(f));
            }

            @Override
            public void onFailure(Error error) {
                preparingCallback.onPrepareFailed(error);
            }
        });
    }

    public String toString() {
        return "Image{" + new StringChain().acceptNullElements().add("size", String.valueOf(this.width) + "x" + String.valueOf(this.height)).add("origin", this.originUrl).add("thumb", this.thumbUrl).toString();
    }

    private Image(String string, int n, int n2) {
        this.originUrl = string;
        this.width = n;
        this.height = n2;
    }

    private boolean isWebImageUrl() {
        return Patterns.WEB_URL.matcher(this.originUrl).matches() || URLUtil.isValidUrl((String)this.originUrl);
    }

    public static void registerCodecs() {
        Image.registerCodec(new Content.Codec(){
            static final String KeyWidth = "width";
            static final String KeyHeight = "height";
            static final String KeyOrigin = "origin";
            static final String KeyThumb = "thumb";

            @Override
            public int type() {
                return 1;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Image.class;
            }

            @Override
            public byte[] makePBBytes(Content content) {
                Image image = (Image)content;
                Im.ImageMsg.Builder builder = Im.ImageMsg.newBuilder();
                builder.setOriginalHeight(image.height);
                builder.setOriginalWidth(image.width);
                builder.setOriginalUrl(image.originUrl);
                if (!Util.empty(image.thumbUrl)) {
                    builder.setThumbnailUrl(image.thumbUrl);
                }
                return ((Im.ImageMsg)builder.build()).toByteArray();
            }

            @Override
            public Content makeChatContent(byte[] byArray) {
                Im.ImageMsg imageMsg = (Im.ImageMsg)((Im.ImageMsg.Builder)Im.ImageMsg.newBuilder().mergeFrom(byArray)).build();
                Image image = new Image(imageMsg.getOriginalUrl(), imageMsg.getOriginalWidth(), imageMsg.getOriginalHeight());
                if (!Util.empty(imageMsg.getThumbnailUrl())) {
                    image.thumbUrl = imageMsg.getThumbnailUrl();
                }
                return image;
            }

            @Override
            public String makeDBString(Content content) {
                Image image = (Image)content;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(KeyWidth, image.width);
                jSONObject.put(KeyHeight, image.height);
                jSONObject.put(KeyOrigin, (Object)image.originUrl);
                if (!Util.empty(image.thumbUrl)) {
                    jSONObject.put(KeyThumb, (Object)image.thumbUrl);
                }
                return jSONObject.toString();
            }

            @Override
            public Content makeChatContent(String string) {
                JSONObject jSONObject = new JSONObject(string);
                Image image = new Image(jSONObject.getString(KeyOrigin), jSONObject.getInt(KeyWidth), jSONObject.getInt(KeyHeight));
                if (jSONObject.has(KeyThumb)) {
                    image.thumbUrl = jSONObject.getString(KeyThumb);
                }
                return image;
            }

            public String toString() {
                return "ImageCodec";
            }
        });
    }
}

