/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat;

import android.support.annotation.NonNull;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;

public final class Message {
    private static final String TAG = "Message";
    private String uuid;
    private Identifiable sender;
    private Identifiable receiver;
    private PushContent pushContent;
    private Long timestamp;
    private State state;
    private String appExtra;
    private Content chatContent;

    public Message() {
    }

    public Message(Identifiable identifiable, Content content) {
        this.chatContent = content;
        this.receiver = identifiable;
        this.timestamp = 0L;
    }

    public Content getContent() {
        return this.chatContent;
    }

    public void setContent(Content content) {
        this.chatContent = content;
    }

    public PushContent getPushContent() {
        return this.pushContent;
    }

    public void setPushContent(PushContent pushContent) {
        this.pushContent = pushContent;
    }

    public Identifiable getSender() {
        return this.sender;
    }

    public void setSender(Identifiable identifiable) {
        this.sender = identifiable;
    }

    public Identifiable getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Identifiable identifiable) {
        this.receiver = identifiable;
    }

    public Identifiable getTarget() {
        if (this.sender instanceof User && this.receiver instanceof User) {
            if (HMR.isMe(this.sender)) {
                return this.receiver;
            }
            if (HMR.isMe(this.receiver)) {
                return this.sender;
            }
            return null;
        }
        return this.receiver;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public String getAppExtra() {
        return this.appExtra;
    }

    public void setAppExtra(String string) {
        this.appExtra = string;
    }

    public State getState() {
        return this.state;
    }

    public void setState(@NonNull State state) {
        if (state == null) {
            Log.e("Source", Trace.once().method("performStarting").msg("newState is <null>"));
            return;
        }
        this.state = state;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        return this.uuid != null && message.uuid != null && this.uuid.equals(message.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "Message{id=}" + this.uuid;
    }

    public static interface State {
    }
}

