/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import com.hummer.im._internals.shared.statis.TextUtils;
import java.io.DataInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class RsaCipher {
    private static final String RSA_PADDING = "RSA/ECB/PKCS1Padding";
    private PublicKey publicKey;
    private int publicMflen = 16;
    private int publicMtail = 5;
    private final ThreadLocal<Cipher> rsaCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(RsaCipher.RSA_PADDING);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new RuntimeException(noSuchPaddingException);
            }
        }
    };

    public void loadPublicKey(InputStream inputStream) {
        byte[] byArray = RsaCipher.readAllBytes(inputStream);
        try {
            PublicKey publicKey;
            this.publicKey = publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    public String encryptTlogAesKey(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        byte[] byArray2 = this.encrypt(byArray);
        StringBuilder stringBuilder = new StringBuilder(8 + byArray2.length * 2);
        stringBuilder.append(TextUtils.length2DecimalChar(byArray.length));
        stringBuilder.append(TextUtils.bytes2hex(byArray2));
        return stringBuilder.toString();
    }

    public byte[] encrypt(byte[] byArray) {
        int n = byArray.length;
        int n2 = n % this.publicMtail;
        int n3 = n2 != 0 ? n + this.publicMtail - n2 : n;
        int n4 = byArray.length;
        if (n2 != 0) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        int n5 = n3 / this.publicMtail * this.publicMflen;
        byte[] byArray3 = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        try {
            byte[] byArray4;
            while (n6 < byArray.length && (n8 = n4 - n6) >= this.publicMtail) {
                byArray4 = this.encrypt(byArray, n6, this.publicMtail, this.publicKey);
                System.arraycopy(byArray4, 0, byArray3, n7, byArray4.length);
                n6 += this.publicMtail;
                n7 += this.publicMflen;
            }
            if (n8 > 0 && n6 < byArray.length) {
                byArray[n6 + this.publicMtail - 1] = (byte)(this.publicMtail - n8);
                byArray4 = this.encrypt(byArray, n6, this.publicMtail, this.publicKey);
                System.arraycopy(byArray4, 0, byArray3, n7, byArray4.length);
            }
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        return byArray3;
    }

    private byte[] encrypt(byte[] byArray, int n, int n2, Key key) {
        Cipher cipher = this.rsaCipher.get();
        cipher.init(1, key);
        byte[] byArray2 = cipher.doFinal(byArray, n, n2);
        return byArray2;
    }

    private static byte[] readAllBytes(InputStream inputStream) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(512);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = -1;
        while ((n = dataInputStream.read()) != -1) {
            arrayList.add((byte)n);
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return byArray;
    }
}

