/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.statis.IJsonSerialize;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsCount
implements IJsonSerialize,
Cloneable {
    private int scode;
    private String uri;
    private String counterName;
    private long value;
    private int invokeCount;

    public MetricsCount(int n, String string, String string2) {
        this.scode = n;
        this.uri = string;
        this.counterName = string2;
    }

    public int getInvokeCount() {
        return this.invokeCount;
    }

    public long getValue() {
        return this.value;
    }

    public synchronized void count(long l, int n) {
        this.value += l;
        this.invokeCount += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject toJson() {
        long l;
        long l2;
        MetricsCount metricsCount = this;
        synchronized (metricsCount) {
            l2 = this.value;
            l = this.invokeCount;
        }
        if (l2 == 0L && l == 0L) {
            return null;
        }
        try {
            metricsCount = new JSONObject();
            metricsCount.put("scode", this.scode);
            metricsCount.put("uri", URLEncoder.encode(this.uri, "utf-8"));
            metricsCount.put("counterName", URLEncoder.encode(this.counterName, "utf-8"));
            metricsCount.put("value", l2);
            metricsCount.put("invokecount", (int)l);
            return metricsCount;
        }
        catch (JSONException jSONException) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", jSONException.getLocalizedMessage()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.i(HiidoReporter.TAG, String.format(Locale.US, "report ex:%s", unsupportedEncodingException.getLocalizedMessage()));
        }
        return null;
    }

    public String getKey() {
        return String.format("%d&%s&%s", this.scode, this.uri, this.counterName);
    }

    protected Object clone() {
        MetricsCount metricsCount = new MetricsCount(this.scode, this.uri, this.counterName);
        metricsCount.value = this.value;
        metricsCount.invokeCount = this.invokeCount;
        return metricsCount;
    }
}

