/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import android.text.TextUtils;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.statis.HttpUtil;
import com.hummer.im._internals.shared.statis.IStatisHttpUtil;
import java.util.Locale;
import java.util.Random;

public abstract class AbstractStatisHttpUtil
implements IStatisHttpUtil {
    protected int mRetryTimeHost = 2;
    protected int mTryTimeIp = 2;
    protected Throwable mThrowable;
    protected String testServer;
    protected int lastTryTimes;
    protected int statusCode;
    protected String reasonPhrase;

    protected String getServerAddr() {
        String string = this.testServer == null || this.testServer.length() == 0 ? this.getUrlService() : this.testServer;
        return string;
    }

    protected String[] getFallbackIps() {
        return this.testServer == null || this.testServer.length() == 0 ? this.getUrlAddress() : new String[]{};
    }

    @Override
    public void setTestServer(String string) {
        this.testServer = string;
    }

    @Override
    public boolean sendSync(String string) {
        return this.sendSyncByTrying(string);
    }

    protected boolean sendSyncByTrying(String string) {
        if (this.sendContent(this.getServerAddr(), string, this.mRetryTimeHost)) {
            return true;
        }
        Object[] objectArray = this.getFallbackIps();
        Log.i(HiidoReporter.TAG, String.format(Locale.US, "report fallback IPs : %s", TextUtils.join((CharSequence)" ", (Object[])objectArray)));
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        int n = this.mTryTimeIp;
        int n2 = 0;
        String string2 = null;
        while (n-- > 0) {
            n2 = new Random().nextInt(objectArray.length);
            string2 = this.asUrl((String)objectArray[n2]);
            if (!this.sendContent(string2, string, 0)) continue;
            return true;
        }
        return false;
    }

    protected boolean get(String string, String string2) {
        return this.getByUrlConn(string, string2);
    }

    protected boolean post(String string, String string2) {
        return this.postByUrlConn(string, string2);
    }

    private boolean getByUrlConn(String string, String string2) {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUtil.HttpResp httpResp = HttpUtil.getByUrlConn(string, string2);
        this.statusCode = httpResp.statusCode;
        this.reasonPhrase = httpResp.reason;
        return httpResp.isSucceed;
    }

    private boolean postByUrlConn(String string, String string2) {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUtil.HttpResp httpResp = HttpUtil.postByUrlConn(string, string2);
        this.statusCode = httpResp.statusCode;
        this.reasonPhrase = httpResp.reason;
        return httpResp.isSucceed;
    }

    protected String asUrl(String string) {
        return String.format(this.getUrlFormat(), string);
    }

    @Override
    public Throwable getLastError() {
        return this.mThrowable;
    }

    @Override
    public int getLastStatusCode() {
        return this.statusCode;
    }

    protected abstract boolean sendContent(String var1, String var2, int var3);

    protected abstract String getUrlService();

    protected abstract String getUrlFormat();

    protected abstract String[] getUrlAddress();
}

