/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared;

import android.text.TextUtils;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.statis.MetricsHttpEncryptUtil;
import com.hummer.im._internals.shared.statis.MetricsWorker;
import com.hummer.im._internals.shared.statis.StatisHttpEncryptUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class HiidoReporter {
    public static final DispatchQueue reportQueue = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_report"));
    public static String TAG = "Reporter";
    private static String host;
    private static String metricsHost;
    private static MetricsWorker metricsWorker;

    public static void setRegion(Region region) {
        switch (region) {
            case China: {
                host = "ylog.hiido.com";
                metricsHost = "klog.hiido.com";
                break;
            }
            case Overseas: {
                host = "hlog.hiido.com";
                metricsHost = "klog.hiido.com";
                break;
            }
            default: {
                Log.e("HiidoReporter", Trace.once().method("setRegion").info("hiido.Reporter | Unknown region: ", (Object)region));
            }
        }
        metricsWorker = new MetricsWorker("44b8f2b988e258e1d036acd459afaacc", new MetricsHttpEncryptUtil(metricsHost, null), new StatisHttpEncryptUtil(host, null));
    }

    public static Map<String, Field> makeFields(Map<String, Integer> map, Map<String, Long> map2, Map<String, String> map3) {
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), Field.from(entry.getValue()));
        }
        for (Map.Entry<String, Number> entry : map2.entrySet()) {
            hashMap.put(entry.getKey(), Field.from((Long)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : map3.entrySet()) {
            hashMap.put(entry.getKey(), Field.from((String)entry.getValue()));
        }
        return hashMap;
    }

    public static void report(final String string, final Map<String, Field> map) {
        Log.i(TAG, "report | " + map);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection httpURLConnection = null;
                try {
                    String string3 = HiidoReporter.queryString(string, map);
                    if (string3 == null) {
                        return;
                    }
                    URL uRL = new URL(String.format(Locale.US, "https://%s/c.gif?%s", host, string3));
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setReadTimeout(6000);
                    httpURLConnection.setConnectTimeout(10000);
                    int n = httpURLConnection.getResponseCode();
                    if (n != 200) {
                        String string2 = HiidoReporter.getStringFromInputStream(httpURLConnection.getErrorStream());
                        Log.w(TAG, "report | Failed: [" + n + "] " + string2);
                    }
                }
                catch (Exception exception) {
                    Log.e(TAG, "report | Exception: " + exception.getLocalizedMessage());
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
        }).start();
    }

    public static void reportActTemporary(final String string, final Map<String, Integer> map, final Map<String, Long> map2, final Map<String, String> map3) {
        reportQueue.async("HiidoReporter::reportActTemporary", new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportHiidoTemporary(string, map, map2, map3);
                }
                catch (Throwable throwable) {
                    Log.e(TAG, String.format(Locale.US, "reportStatisticContentTemporary error:%s", throwable.getLocalizedMessage()));
                }
            }
        });
    }

    public static void reportReturnCode(final int n, final String string, final long l, final String string2) {
        reportQueue.async("HiidoReporter::reportReturenCode", new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportReturnCode(n, string, l, string2);
                }
                catch (Throwable throwable) {
                    Log.e(TAG, String.format(Locale.US, "reportReturnCode error:%s", throwable.getLocalizedMessage()));
                }
            }
        });
    }

    public static void reportReturnCodeTemporary(final int n, final String string, final long l, final String string2) {
        reportQueue.async("HiidoReporter::reportReturnCodeTemporary", new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportReturnCodeTemporary(n, string, l, string2);
                }
                catch (Throwable throwable) {
                    Log.e(TAG, String.format(Locale.US, "reportReturnCodeTemporary error:%s", throwable.getLocalizedMessage()));
                }
            }
        });
    }

    public static void reportReturnCodeTemporary(String string, long l, int n) {
        if (l < 0L) {
            return;
        }
        String string2 = string + "/" + String.valueOf(HMRContext.appId);
        HiidoReporter.reportReturnCodeTemporary(50216, string2, l, String.valueOf(n));
    }

    public static void reportCount(final int n, final String string, final String string2, final long l) {
        reportQueue.async("HiidoReporter::reportCount", new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportCount(n, string, string2, l);
                }
                catch (Throwable throwable) {
                    Log.e(TAG, String.format(Locale.US, "report count error:%s", throwable.getLocalizedMessage()));
                }
            }
        });
    }

    public static void reportCount(final int n, final String string, final String string2, final long l, final int n2) {
        reportQueue.async("HiidoReporter::reportCountWithtimes", new Runnable(){

            @Override
            public void run() {
                try {
                    metricsWorker.reportCount(n, string, string2, l, n2);
                }
                catch (Throwable throwable) {
                    Log.e(TAG, String.format(Locale.US, "reportCount error:%s", throwable.getLocalizedMessage()));
                }
            }
        });
    }

    private static String queryString(String string, Map<String, Field> map) {
        long l = System.currentTimeMillis() / 1000L;
        String string2 = HiidoReporter.actionKey(string, l);
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format(Locale.US, "act=%s", string));
        arrayList.add(String.format(Locale.US, "time=%d", l));
        arrayList.add(String.format(Locale.US, "key=%s", string2));
        for (Map.Entry<String, Field> entry : map.entrySet()) {
            Field field = entry.getValue();
            if (!HiidoReporter.isAcceptableField(field)) {
                Log.w(TAG, Trace.once("Null Field: %s", entry.getKey()));
                continue;
            }
            try {
                String string3 = URLEncoder.encode(entry.getValue().toString(), "utf-8");
                arrayList.add(String.format(Locale.US, "%s=%s", entry.getKey(), string3));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.w(TAG, Trace.once("Invalid Field: %s = %s", entry.getKey(), field));
            }
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    private static String getStringFromInputStream(InputStream inputStream) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        String string = byteArrayOutputStream.toString();
        byteArrayOutputStream.close();
        return string;
    }

    public static String actionKey(String string, long l) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.e("HiidoReporter", Trace.once().method("actionKey").info("act", string));
        }
        String string2 = string + String.valueOf(l) + "HiidoYYSystem";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string2.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                String string3 = Integer.toHexString(by & 0xFF);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                stringBuilder.append(string3);
            }
            return stringBuilder.toString().toLowerCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    private static boolean isAcceptableField(Field field) {
        return field != null;
    }

    static {
        HiidoReporter.setRegion(Region.Overseas);
    }

    public static class Field {
        private String value;

        public static Field from(Integer n) {
            return new Field(String.valueOf(n));
        }

        public static Field from(Long l) {
            return new Field(String.valueOf(l));
        }

        public static Field from(String string) {
            return new Field(string);
        }

        public String toString() {
            return this.value;
        }

        private Field(String string) {
            this.value = string;
        }
    }

    public static enum Region {
        China,
        Overseas;

    }
}

